package pl.shockah.ts.particles;

import pl.shockah.glib.animfx.Animation;
import pl.shockah.glib.animfx.TimelineObject;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.particle.Particle;
import pl.shockah.glib.particle.ParticleSystem;
import pl.shockah.glib.particle.ParticleType;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;

public class PtSkidJump extends ParticleType {
	protected static final ParticleType pt = new PtSkidJump();
	
	public static void make(ParticleSystem ps, Vector2d pos) {
		pt.spawn(ps,pos);
	}
	
	public PtSkidJump() {
		super(Assets.ptFuzzy);
	}
	
	public Particle create(ParticleSystem ps, IVector2 pos, Object... args) {
		CustomParticle cp = new CustomParticle(ps,this);
		cp.size.set(3d,8d);
		cp.pos = pos.toDouble();
		cp.vel = Vector2d.make(.3d+(Main.rand.nextDouble()*.2d),Main.rand.nextDouble()*360d);
		cp.rotation = Main.rand.nextDouble()*360d;
		return cp;
	}
	
	protected void onUpdate(Particle p) {
		super.onUpdate(p);
		CustomParticle cp = (CustomParticle)p;
		
		cp.anim.update();
		if (cp.anim.isFinished()) cp.dead = true;
	}
	
	protected void onRender(Particle p, Graphics g) {
		CustomParticle cp = (CustomParticle)p;
		
		g.setColor(cp.tlColor.getState(cp.anim));
		image.scale = p.size.Div(image.getSize().toDouble());
		
		image.rotation.angle = p.rotation;
		g.draw(image,p.pos);
		image.rotation.angle = p.rotation+90;
		g.draw(image,p.pos);
		
		image.rotation.angle = 0;
		image.scale.set(1d,1d);
	}
	
	protected class CustomParticle extends Particle {
		protected final Animation anim = new Animation();
		protected final TimelineObject<Color> tlColor = new TimelineObject<>();
		
		public CustomParticle(ParticleSystem ps, ParticleType pt) {
			super(ps,pt);
			
			tlColor.add(Color.Yellow,0);
			tlColor.copyLast(30);
			tlColor.add(Color.Yellow.alpha(0f),40);
			anim.add(tlColor);
		}
	}
}