package pl.shockah.ts.entities;

import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;
import pl.shockah.ts.entities.waterblur.IWaterBlur;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;
import pl.shockah.ts.gameplay.ITimeAffected;

public class EntityDiamond extends EntityCollidable implements IWaterBlur,ITimeAffected {
	protected final ERarity rarity;
	protected double sin;
	
	public EntityDiamond(ERarity rarity) {
		baseDepth = 10;
		
		this.rarity = rarity;
		sin = Main.rand.nextDouble()*360d;
	}
	
	protected void onUpdate() {
		sin += 1.3d*Game.me.time.getSpeed(this);
		if (sin >= 360d) sin -= 360d;
	}
	
	protected void onRender(Graphics g) {
		g.setColor(Color.White.alpha(1f/3f*WaterBlur.blurAlpha));
		g.draw(rarity.getImage(),pos.x,pos.y+Math.sin(Math.toRadians(sin-60))*4);
		g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
		g.draw(rarity.getImage(),pos.x,pos.y+Math.sin(Math.toRadians(sin))*4);
	}
	
	public boolean affectedSlow() {return true;}
	public boolean affectedStop() {return true;}
	
	public static enum ERarity {
		Blue(Assets.ssDiamond.getImage(0)), Red(Assets.ssDiamond.getImage(1));
		
		private final Image image;
		
		private ERarity(Image image) {
			this.image = image;
		}
		
		public Image getImage() {
			return image;
		}
	}
}