package pl.shockah.ts.entities;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.waterblur.WaterBlur;

public class EntityBoxPushable extends EntityBoxGravity {
	protected void onCreate() {
		super.onCreate();
		shape = new Rectangle(pos.x,pos.y,24,24);
	}
	
	protected void onRegister() {
		new Renderable(this,baseDepth-.1d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
				g.draw(Assets.ssBoxes.getImage(2),pos.x,pos.y);
			}
		}.create();
		
		new Renderable(this,baseDepth-.2d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
				g.draw(Assets.ssTileBorderThin.getImage(0),pos.x,pos.y);
			}
		}.create();
	}
}