package pl.shockah.ts.states;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.color.Colorb;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.View;
import pl.shockah.glib.state.transitions.TransitionThroughColor;
import pl.shockah.ts.Assets;
import pl.shockah.ts.menu.MenuElButton;
import pl.shockah.ts.menu.MenuSet;

public class StateMenuMain extends State {
	public StateMenuMain() {
		views.add(new View(new Vector2i(960,720)));
	}
	
	protected void onCreate() {
		new EntityRenderable(){
			protected void onRender(Graphics g) {
				Vector2i size = getDisplaySize();
				
				Color c1 = new Colorb(0,138,255), c2 = new Colorb(255,167,68);
				new Rectangle(size).drawMulticolor(g,true,c1,c1,c2,c2);
				g.setColor(Color.White);
				g.draw(Assets.sLogo,size.x/2,size.y/4);
			}
		}.create();
		
		Vector2i size = State.get().getDisplaySize();
		new MenuSet().addElements(
				new MenuElButton().setText("Play").setAction(new Runnable(){
					public void run() {
						State.change(new StateGame(),new TransitionThroughColor(.025f,true),new TransitionThroughColor(.025f,true));
					}
				}),
				new MenuElButton().setText("Options").setAction(new Runnable(){
					public void run() {
						State.change(new StateMenuOptions(),new TransitionThroughColor(.025f,true),new TransitionThroughColor(.025f,true));
					}
				}),
				new MenuElButton().setText("Stats").setAction(new Runnable(){
					public void run() {
						
					}
				}),
				new MenuElButton().setText("Exit").setAction(new Runnable(){
					public void run() {
						State.change(null,new TransitionThroughColor(.025f,true),null);
					}
				})
		).setSize(240,40).setSeparator(16).setFont(Assets.font24).create(new Vector2d(size.x/2,size.y/2));
	}
}