package pl.shockah.ts.entities;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.gameplay.Game;

public class EntityWall extends EntityCollidable {
	protected boolean[] sides = new boolean[8];
	protected int frame = 0;
	
	protected void onCreate() {
		shape = new Rectangle(pos.x,pos.y,24,24);
	}
	
	protected void onFirstUpdate() {
		for (int i = 0; i < sides.length; i++) sides[i] = false;
		for (EntityWall wall : Entities.getType(EntityWall.class)) {
			if (isSide(0,-1,wall)) sides[0] = true;
			if (isSide(0,1,wall)) sides[1] = true;
			if (isSide(-1,0,wall)) sides[2] = true;
			if (isSide(1,0,wall)) sides[3] = true;
			if (isSide(-1,-1,wall)) sides[4] = true;
			if (isSide(1,-1,wall)) sides[5] = true;
			if (isSide(-1,1,wall)) sides[6] = true;
			if (isSide(1,1,wall)) sides[7] = true;
		}
		for (int i = 0; i < 4; i++) frame += sides[i] ? 1<<i : 0;
	}
	protected boolean isSide(int x, int y, EntityWall wall) {
		return wall.pos.x == pos.x+x*24 && wall.pos.y == pos.y+y*24;
	}
	
	protected void onRegister() {
		new Renderable(this,0d-.1d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White);
				switch (Game.me.theme) {
					case Jungle: {
						g.draw(Assets.sTileDirt.part((int)pos.x%Assets.sTileDirt.getTextureWidth(),(int)pos.y%Assets.sTileDirt.getTextureWidth(),24,24),pos.x,pos.y);
					} break;
					case Plane: {
						g.draw(Assets.sTileMetal.part((int)pos.x%Assets.sTileMetal.getTextureWidth(),(int)pos.y%Assets.sTileMetal.getTextureWidth(),24,24),pos.x,pos.y);
					} break;
				}
			}
		}.create();
		
		new Renderable(this,0d-.2d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White);
				switch (Game.me.theme) {
					case Jungle: {
						if (!sides[0] && pos.y > 0) g.draw(Assets.ssTileGrass.getImage((sides[2]&&!sides[4]?1:0)+(sides[3]&&!sides[5]?2:0)),pos.x,pos.y);
					} break;
					default: break;
				}
			}
		}.create();
		
		new Renderable(this,0d-.3d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White);
				switch (Game.me.theme) {
					case Jungle: {
						g.draw(Assets.ssTileBorder.getImage(frame),pos.x,pos.y);
						if (sides[0] && sides[2] && !sides[4]) g.draw(Assets.ssTileBorder.getImage(16),pos.x,pos.y);
						if (sides[0] && sides[3] && !sides[5]) g.draw(Assets.ssTileBorder.getImage(17),pos.x,pos.y);
						if (sides[1] && sides[2] && !sides[6]) g.draw(Assets.ssTileBorder.getImage(18),pos.x,pos.y);
						if (sides[1] && sides[3] && !sides[7]) g.draw(Assets.ssTileBorder.getImage(19),pos.x,pos.y);
					} break;
					case Plane: {
						g.draw(Assets.ssTileBorderMetal.getImage(frame),pos.x,pos.y);
						if (sides[0] && sides[2] && !sides[4]) g.draw(Assets.ssTileBorderMetal.getImage(16),pos.x,pos.y);
						if (sides[0] && sides[3] && !sides[5]) g.draw(Assets.ssTileBorderMetal.getImage(17),pos.x,pos.y);
						if (sides[1] && sides[2] && !sides[6]) g.draw(Assets.ssTileBorderMetal.getImage(18),pos.x,pos.y);
						if (sides[1] && sides[3] && !sides[7]) g.draw(Assets.ssTileBorderMetal.getImage(19),pos.x,pos.y);
					} break;
				}
			}
		}.create();
	}
}