package pl.shockah.ts.entities;

import pl.shockah.Util;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EntityBoxFalling extends EntityBoxPushable {
	protected float falling = -1;
	
	protected void onCreate() {
		super.onCreate();
		shape = new Rectangle(pos.x,pos.y,24,24);
	}
	
	protected void onUpdate() {
		double mod = Game.me.time.getSpeed(this);
		if (mod == 0) return;
		
		if (falling == -1 && collidesAt(Util.getAllOf(Entities.getTypes(EntityPlayer.class,EntityBoxGravity.class),EntityCollidable.class),pos.x,pos.y-1)) falling = 20;
		if (falling > 0) falling -= 1*mod;
		if (falling <= 0 && falling > -1) super.onUpdate();
	}
	
	protected void onRegister() {
		new Renderable(this,baseDepth-.1d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
				g.draw(Assets.ssBoxes.getImage(1),pos.x,pos.y);
			}
		}.create();
		
		new Renderable(this,baseDepth-.2d){
			protected void onRender(Graphics g) {
				g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
				g.draw(Assets.ssTileBorderThin.getImage(0),pos.x,pos.y);
			}
		}.create();
	}
}