/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.menu;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pl.shockah.FieldObj;
import pl.shockah.Math2;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.font.ETextAlign;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.gl.font.TextHelper;
import pl.shockah.glib.gl.tex.Atlas;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.input.MInput;
import pl.shockah.glib.state.State;
import pl.shockah.ts.Assets;
import pl.shockah.ts.menu.MenuElement;
import pl.shockah.ts.menu.MenuSet;

public class MenuElChoose<T>
extends MenuElement {
    public static final Atlas atlas = Assets.aFrameText;
    protected final ToString<T> tostring;
    protected List<T> options = new LinkedList<T>();
    protected String text = "";
    protected FieldObj field = null;
    protected float selectedAlpha = 0.0f;
    protected float openAlpha = 0.0f;
    protected boolean open = false;
    protected int selected = 0;

    public MenuElChoose() {
        this(null);
    }

    public MenuElChoose(ToString<T> tostring) {
        this.tostring = tostring;
    }

    public MenuElChoose<T> setText(String text) {
        this.text = text;
        return this;
    }

    public MenuElChoose<T> setAction(FieldObj field) {
        this.field = field;
        return this;
    }

    public MenuElChoose<T> addOptions(T ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    protected void create(MenuSet menu, boolean selected) {
        this.selectedAlpha = selected ? 1.0f : 0.0f;
    }

    @Override
    protected boolean update(MenuSet menu, Rectangle rect, Font font, boolean selected) {
        font = Assets.font16;
        this.selectedAlpha = Math2.limit(this.selectedAlpha + 0.1f * (float)(selected ? 1 : -1), 0.0f, 1.0f);
        this.openAlpha = Math2.limit(this.openAlpha + 0.1f * (float)(selected && this.open ? 1 : -1), 0.0f, 1.0f);
        if (this.open) {
            if (KInput.isPressed(200)) {
                this.selected = Math.max(this.selected - 1, 0);
            }
            if (KInput.isPressed(208)) {
                this.selected = Math.min(this.selected + 1, this.options.size() - 1);
            }
            if (selected && KInput.isPressed(28)) {
                this.open = false;
                this.setValue();
            }
            Vector2d size2 = new Vector2d();
            for (T t : this.options) {
                double w = font.getWidth(this.toString(t));
                if (w > size2.x) {
                    size2.x = w;
                }
                size2.y += (double)font.getHeight();
            }
            Rectangle rect2 = new Rectangle(State.get().getDisplaySize().toDouble().div(2.0).sub(size2.Div(2.0)), size2);
            int i = 0;
            while (i < this.options.size()) {
                Rectangle rect3 = new Rectangle(rect2.pos.Add(0.0, rect2.size.y / (double)this.options.size() * (double)i), new Vector2d(rect2.size.x, rect2.size.y / (double)this.options.size()));
                if (MInput.inRectangle(new Rectangle(0.0, rect3.pos.y, State.get().getDisplaySize().x, rect3.size.y))) {
                    if (!MInput.getDeltaPos().equals(new Vector2i())) {
                        this.selected = i;
                    }
                    if (selected && MInput.isPressed(0)) {
                        this.open = false;
                        this.setValue();
                    }
                    return !MInput.getDeltaPos().equals(new Vector2i());
                }
                ++i;
            }
        } else {
            if (selected && KInput.isPressed(28)) {
                if (this.options.size() == 2) {
                    this.selected = this.selected == 0 ? 1 : 0;
                } else {
                    this.open = true;
                }
            }
            if (MInput.inRectangle(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y))) {
                if (selected && MInput.isPressed(0)) {
                    if (this.options.size() == 2) {
                        this.selected = this.selected == 0 ? 1 : 0;
                    } else {
                        this.open = true;
                    }
                }
                return !MInput.getDeltaPos().equals(new Vector2i());
            }
        }
        return false;
    }

    @Override
    protected boolean lockedSelection() {
        return this.open;
    }

    protected void setValue() {
        try {
            if (this.field != null) {
                this.field.set(this.options.get(this.selected));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void render(MenuSet menu, Graphics g, Rectangle rect, Font font, boolean selected) {
        g.setColor(Color.Black.alpha(0.5f));
        g.draw(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y));
        g.setColor(Color.Black.alpha(0.5f * this.selectedAlpha));
        g.draw(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y));
        g.setColor(Color.Black);
        int yy = -1;
        while (yy <= 1) {
            int xx = -1;
            while (xx <= 1) {
                TextHelper.draw(g, font, rect.pos.Add(xx, yy).add(rect.size.x / 2.0 - 24.0, rect.size.y / 2.0), (CharSequence)this.text, ETextAlign.MiddleRight);
                TextHelper.draw(g, font, rect.pos.Add(xx, yy).add(rect.size.x / 2.0 + 24.0, rect.size.y / 2.0), (CharSequence)this.toStringOption(), ETextAlign.MiddleLeft);
                xx += 2;
            }
            yy += 2;
        }
        g.setColor(Color.White);
        TextHelper.draw(g, font, rect.pos.Add(rect.size.x / 2.0 - 24.0, rect.size.y / 2.0), (CharSequence)this.text, ETextAlign.MiddleRight);
        TextHelper.draw(g, font, rect.pos.Add(rect.size.x / 2.0 + 24.0, rect.size.y / 2.0), (CharSequence)this.toStringOption(), ETextAlign.MiddleLeft);
    }

    @Override
    protected void render2(MenuSet menu, Graphics g, Rectangle rect, Font font, boolean selected) {
        font = Assets.font16;
        if (!selected || this.openAlpha <= 0.0f) {
            return;
        }
        Vector2d size2 = new Vector2d();
        for (T t : this.options) {
            double w = font.getWidth(this.toString(t));
            if (w > size2.x) {
                size2.x = w;
            }
            size2.y += (double)font.getHeight();
        }
        Rectangle rect2 = new Rectangle(State.get().getDisplaySize().toDouble().div(2.0).sub(size2.Div(2.0)), size2.Add(8.0, 8.0));
        g.setColor(Color.Black.alpha(0.75f * this.openAlpha));
        g.draw(new Rectangle(0.0, rect2.pos.y, State.get().getDisplaySize().x, rect2.size.y));
        int i = 0;
        for (T t : this.options) {
            g.setColor(Color.Black.alpha(this.openAlpha * (this.selected == i ? 1.0f : 0.5f)));
            int yy = -1;
            while (yy <= 1) {
                int xx = -1;
                while (xx <= 1) {
                    TextHelper.draw(g, font, rect2.pos.Add(xx, (float)yy + (float)font.getHeight() * ((float)i + 0.5f)).add(rect2.size.x / 2.0, 6.0), (CharSequence)this.toString(t), ETextAlign.MiddleCenter);
                    xx += 2;
                }
                yy += 2;
            }
            g.setColor(Color.White.alpha(this.openAlpha * (this.selected == i ? 1.0f : 0.5f)));
            TextHelper.draw(g, font, rect2.pos.Add(rect2.size.x / 2.0, 6.0).add(0.0, (float)font.getHeight() * ((float)i + 0.5f)), (CharSequence)this.toString(t), ETextAlign.MiddleCenter);
            ++i;
        }
    }

    protected String toStringOption() {
        return this.options.isEmpty() ? "" : this.toString(this.options.get(this.selected));
    }

    protected String toString(T t) {
        return this.tostring == null ? t.toString() : this.tostring.toString(t);
    }

    public static abstract class ToString<T> {
        public abstract String toString(T var1);
    }
}

