/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.menu;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2f;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.ts.menu.MenuElement;

public class MenuSet
extends EntityRenderable {
    protected final List<MenuElement> elements = new LinkedList<MenuElement>();
    protected Font font = null;
    protected Vector2d size = new Vector2d();
    protected double separator = 0.0;
    protected int selected = 0;

    public MenuSet setSize(Vector2d v) {
        return this.setSize(v.x, v.y);
    }

    public MenuSet setSize(Vector2f v) {
        return this.setSize(v.x, v.y);
    }

    public MenuSet setSize(Vector2i v) {
        return this.setSize(v.x, v.y);
    }

    public MenuSet setSize(double x, double y) {
        this.size.set(x, y);
        return this;
    }

    public MenuSet setSeparator(double separator) {
        this.separator = separator;
        return this;
    }

    public MenuSet setFont(Font font) {
        this.font = font;
        return this;
    }

    public MenuSet addElements(MenuElement ... elements) {
        this.elements.addAll(Arrays.asList(elements));
        return this;
    }

    @Override
    protected void onCreate() {
        int i = 0;
        for (MenuElement mel : this.elements) {
            mel.create(this, this.selected == i++);
        }
    }

    @Override
    protected void onUpdate() {
        double yy = 0.0;
        int i = 0;
        int newSelected = -1;
        boolean locked = this.elements.get(this.selected).lockedSelection();
        if (!locked) {
            if (KInput.isPressed(200)) {
                this.selected = Math.max(this.selected - 1, 0);
            }
            if (KInput.isPressed(208)) {
                this.selected = Math.min(this.selected + 1, this.elements.size() - 1);
            }
        }
        Vector2d v = new Vector2d(this.size.x / 2.0, this.size.y / 2.0);
        for (MenuElement mel : this.elements) {
            if (mel.update(this, new Rectangle(this.pos.Add(0.0, yy).sub(v), this.size), this.font, this.selected == i++)) {
                newSelected = i - 1;
            }
            yy += this.size.y + this.separator;
        }
        if (!locked && newSelected != -1) {
            this.selected = newSelected;
        }
    }

    @Override
    protected void onRender(Graphics g) {
        double yy = 0.0;
        int i = 0;
        Vector2d v = new Vector2d(this.size.x / 2.0, this.size.y / 2.0);
        for (MenuElement mel : this.elements) {
            mel.render(this, g, new Rectangle(this.pos.Add(0.0, yy).sub(v), this.size), this.font, this.selected == i++);
            yy += this.size.y + this.separator;
        }
        yy = 0.0;
        i = 0;
        v.set(this.size.x / 2.0, this.size.y / 2.0);
        for (MenuElement mel : this.elements) {
            mel.render2(this, g, new Rectangle(this.pos.Add(0.0, yy).sub(v), this.size), this.font, this.selected == i++);
            yy += this.size.y + this.separator;
        }
    }
}

