/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.gameplay.Game;

public class EntityWall
extends EntityCollidable {
    protected boolean[] sides = new boolean[8];
    protected int frame = 0;

    @Override
    protected void onCreate() {
        this.shape = new Rectangle(this.pos.x, this.pos.y, 24.0, 24.0);
    }

    @Override
    protected void onFirstUpdate() {
        int i = 0;
        while (i < this.sides.length) {
            this.sides[i] = false;
            ++i;
        }
        for (EntityWall wall : Entities.getType(EntityWall.class)) {
            if (this.isSide(0, -1, wall)) {
                this.sides[0] = true;
            }
            if (this.isSide(0, 1, wall)) {
                this.sides[1] = true;
            }
            if (this.isSide(-1, 0, wall)) {
                this.sides[2] = true;
            }
            if (this.isSide(1, 0, wall)) {
                this.sides[3] = true;
            }
            if (this.isSide(-1, -1, wall)) {
                this.sides[4] = true;
            }
            if (this.isSide(1, -1, wall)) {
                this.sides[5] = true;
            }
            if (this.isSide(-1, 1, wall)) {
                this.sides[6] = true;
            }
            if (!this.isSide(1, 1, wall)) continue;
            this.sides[7] = true;
        }
        i = 0;
        while (i < 4) {
            this.frame += this.sides[i] ? 1 << i : 0;
            ++i;
        }
    }

    protected boolean isSide(int x, int y, EntityWall wall) {
        return wall.pos.x == this.pos.x + (double)(x * 24) && wall.pos.y == this.pos.y + (double)(y * 24);
    }

    @Override
    protected void onRegister() {
        new Renderable(this, -0.1){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White);
                switch (Game.me.theme) {
                    case Jungle: {
                        g.draw((ITextureSupplier)Assets.sTileDirt.part((int)EntityWall.this.pos.x % Assets.sTileDirt.getTextureWidth(), (int)EntityWall.this.pos.y % Assets.sTileDirt.getTextureWidth(), 24, 24), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        break;
                    }
                    case Plane: {
                        g.draw((ITextureSupplier)Assets.sTileMetal.part((int)EntityWall.this.pos.x % Assets.sTileMetal.getTextureWidth(), (int)EntityWall.this.pos.y % Assets.sTileMetal.getTextureWidth(), 24, 24), EntityWall.this.pos.x, EntityWall.this.pos.y);
                    }
                }
            }
        }.create();
        new Renderable(this, -0.2){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White);
                switch (Game.me.theme) {
                    case Jungle: {
                        if (EntityWall.this.sides[0] || !(EntityWall.this.pos.y > 0.0)) break;
                        g.draw((ITextureSupplier)Assets.ssTileGrass.getImage((EntityWall.this.sides[2] && !EntityWall.this.sides[4] ? 1 : 0) + (EntityWall.this.sides[3] && !EntityWall.this.sides[5] ? 2 : 0)), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        break;
                    }
                }
            }
        }.create();
        new Renderable(this, -0.3){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White);
                switch (Game.me.theme) {
                    case Jungle: {
                        g.draw((ITextureSupplier)Assets.ssTileBorder.getImage(EntityWall.this.frame), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        if (EntityWall.this.sides[0] && EntityWall.this.sides[2] && !EntityWall.this.sides[4]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorder.getImage(16), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (EntityWall.this.sides[0] && EntityWall.this.sides[3] && !EntityWall.this.sides[5]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorder.getImage(17), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (EntityWall.this.sides[1] && EntityWall.this.sides[2] && !EntityWall.this.sides[6]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorder.getImage(18), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (!EntityWall.this.sides[1] || !EntityWall.this.sides[3] || EntityWall.this.sides[7]) break;
                        g.draw((ITextureSupplier)Assets.ssTileBorder.getImage(19), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        break;
                    }
                    case Plane: {
                        g.draw((ITextureSupplier)Assets.ssTileBorderMetal.getImage(EntityWall.this.frame), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        if (EntityWall.this.sides[0] && EntityWall.this.sides[2] && !EntityWall.this.sides[4]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorderMetal.getImage(16), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (EntityWall.this.sides[0] && EntityWall.this.sides[3] && !EntityWall.this.sides[5]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorderMetal.getImage(17), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (EntityWall.this.sides[1] && EntityWall.this.sides[2] && !EntityWall.this.sides[6]) {
                            g.draw((ITextureSupplier)Assets.ssTileBorderMetal.getImage(18), EntityWall.this.pos.x, EntityWall.this.pos.y);
                        }
                        if (!EntityWall.this.sides[1] || !EntityWall.this.sides[3] || EntityWall.this.sides[7]) break;
                        g.draw((ITextureSupplier)Assets.ssTileBorderMetal.getImage(19), EntityWall.this.pos.x, EntityWall.this.pos.y);
                    }
                }
            }
        }.create();
    }
}

