/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.tanks;

import java.util.ArrayList;
import java.util.List;
import pl.shockah.Math2;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.tanks.Assets;
import pl.shockah.tanks.Game;
import pl.shockah.tanks.Main;

public class EntityTank
extends EntityRenderable {
    public Color color = Color.fromHSB(Main.rand.nextFloat(), 0.5f + Main.rand.nextFloat() * 0.5f, 1.0f);
    public double rotation = 0.0;
    public double rotation2 = 0.0;
    protected final int frameLength = 4;
    protected final int frameMax = Assets.ssTankTires.getCount() * 4;
    protected final int blockFireMax = 60;
    protected int frame = 0;
    protected int blockFire = 0;
    protected List<TiresGhost> tires = new ArrayList<TiresGhost>();

    @Override
    protected void onUpdate() {
        this.pos.x = Math2.limit(this.pos.x, 0.0, Game.mapSize.x);
        this.pos.y = Math2.limit(this.pos.y, 0.0, Game.mapSize.y);
    }

    @Override
    protected void onRegister() {
        new Renderable(this, -0.1){

            @Override
            protected void onRender(Graphics g) {
                Image imgTires = Assets.ssTankTires.getImage(0);
                for (TiresGhost tg : EntityTank.this.tires) {
                    g.setColor(Color.Maroon.alpha(0.33333334f * tg.alpha));
                    imgTires.rotation.angle = tg.rotation;
                    g.draw((ITextureSupplier)imgTires, (IVector2)tg.pos);
                }
                int i = 0;
                while (i < EntityTank.this.tires.size()) {
                    TiresGhost tg = EntityTank.this.tires.get(i);
                    tg.alpha -= 0.011764706f;
                    if (tg.alpha <= 0.0f) {
                        EntityTank.this.tires.remove(i--);
                    }
                    ++i;
                }
            }
        }.create();
        new Renderable(this, -0.2){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White);
                Image imgTires = Assets.ssTankTires.getImage(EntityTank.this.frame / 4);
                imgTires.rotation.angle = EntityTank.this.rotation;
                g.draw((ITextureSupplier)imgTires, (IVector2)EntityTank.this.pos);
            }
        }.create();
        new Renderable(this, -0.3){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(EntityTank.this.color);
                Assets.sTankBase.rotation.angle = EntityTank.this.rotation;
                g.draw((ITextureSupplier)Assets.sTankBase, (IVector2)EntityTank.this.pos);
            }
        }.create();
        new Renderable(this, -0.4){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(EntityTank.this.color);
                Assets.sTankTurret.rotation.angle = EntityTank.this.rotation2 + EntityTank.this.rotation;
                g.draw((ITextureSupplier)Assets.sTankTurret, (IVector2)EntityTank.this.pos);
            }
        }.create();
    }

    protected static class TiresGhost {
        protected final Vector2d pos;
        protected final double rotation;
        protected float alpha = 1.0f;

        public TiresGhost(Vector2d pos, double rotation) {
            this.pos = pos;
            this.rotation = rotation;
        }
    }
}

