/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.state.transitions;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.transitions.Transition;

public class TransitionThroughColor
extends Transition {
    protected final Color color;
    protected final float baseSpeed;
    protected final boolean runUpdate;
    protected float alpha;
    protected float incr;

    public TransitionThroughColor() {
        this(Color.Black, 0.05f, false);
    }

    public TransitionThroughColor(Color color) {
        this(color, 0.05f, false);
    }

    public TransitionThroughColor(boolean runUpdate) {
        this(Color.Black, 0.05f, runUpdate);
    }

    public TransitionThroughColor(Color color, boolean runUpdate) {
        this(color, 0.05f, runUpdate);
    }

    public TransitionThroughColor(float baseSpeed) {
        this(Color.Black, baseSpeed, false);
    }

    public TransitionThroughColor(Color color, float baseSpeed) {
        this(color, baseSpeed, false);
    }

    public TransitionThroughColor(float baseSpeed, boolean runUpdate) {
        this(Color.Black, baseSpeed, runUpdate);
    }

    public TransitionThroughColor(Color color, float baseSpeed, boolean runUpdate) {
        this.color = color;
        this.baseSpeed = baseSpeed;
        this.runUpdate = runUpdate;
    }

    @Override
    public void init(boolean in) {
        this.alpha = in ? 1 : 0;
        this.incr = (float)(in ? -1 : 1) * this.baseSpeed;
    }

    @Override
    public boolean update() {
        this.alpha += this.incr;
        return this.incr < 0.0f && this.alpha <= 0.0f || this.incr > 0.0f && this.alpha >= 1.0f;
    }

    @Override
    public void render(Graphics g) {
        g.setColor(this.color.setAlpha(this.alpha));
        g.toggleAbsolute();
        g.draw(new Rectangle(new Vector2d(), State.get().getDisplaySize()));
        g.toggleAbsolute();
    }

    @Override
    public boolean shouldUpdate() {
        return this.runUpdate;
    }
}

