/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.color;

import pl.shockah.glib.gl.color.Color;

public final class ColorfMutable
extends Color {
    public float r;
    public float g;
    public float b;
    public float a;

    public ColorfMutable(int v) {
        this(v, 255);
    }

    public ColorfMutable(int v, int a) {
        this(v, v, v, a);
    }

    public ColorfMutable(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ColorfMutable(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public ColorfMutable(float v) {
        this(v, 1.0f);
    }

    public ColorfMutable(float v, float a) {
        this(v, v, v, a);
    }

    public ColorfMutable(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public ColorfMutable(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public int R() {
        return (int)(this.r * 255.0f);
    }

    @Override
    public int G() {
        return (int)(this.g * 255.0f);
    }

    @Override
    public int B() {
        return (int)(this.b * 255.0f);
    }

    @Override
    public int A() {
        return (int)(this.a * 255.0f);
    }

    @Override
    public float Rf() {
        return this.r;
    }

    @Override
    public float Gf() {
        return this.g;
    }

    @Override
    public float Bf() {
        return this.b;
    }

    @Override
    public float Af() {
        return this.a;
    }

    @Override
    public void copy(Color color) {
        this.r = color.Rf();
        this.g = color.Gf();
        this.b = color.Bf();
        this.a = color.Af();
    }
}

