/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom;

import org.lwjgl.opengl.GL11;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;

public class Line
extends Shape
implements IInterpolatable<Line> {
    public Vector2d pos1;
    public Vector2d pos2;

    public Line(double x1, double y1, double x2, double y2) {
        this.pos1 = new Vector2d(x1, y1);
        this.pos2 = new Vector2d(x2, y2);
    }

    public Line(IVector2 pos1, IVector2 pos2) {
        this.pos1 = pos1.toDouble();
        this.pos2 = pos2.toDouble();
    }

    public Line(Line line) {
        this.pos1 = line.pos1.copyMe();
        this.pos2 = line.pos2.copyMe();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Line)) {
            return false;
        }
        Line e = (Line)other;
        return this.pos1.equals(e.pos1) && this.pos2.equals(e.pos2);
    }

    public String toString() {
        return String.format("[Line: %s -> %s]", this.pos1, this.pos2);
    }

    @Override
    public Shape copy() {
        return this.copyMe();
    }

    @Override
    public Line copyMe() {
        return new Line(this);
    }

    @Override
    public Rectangle getBoundingBox() {
        double xmin = Math.min(this.pos1.x, this.pos2.x);
        double xmax = Math.max(this.pos1.x, this.pos2.x);
        double ymin = Math.min(this.pos1.y, this.pos2.y);
        double ymax = Math.max(this.pos1.y, this.pos2.y);
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public Vector2d translate(double x, double y) {
        this.pos1.add(x, y);
        this.pos2.add(x, y);
        return new Vector2d(x, y);
    }

    @Override
    public Vector2d translateTo(double x, double y) {
        Vector2d v = new Vector2d(x - this.pos1.x, y - this.pos1.y);
        this.pos1.add(v);
        this.pos2.add(v);
        return v;
    }

    @Override
    public void draw(Graphics g) {
        this.draw(g, false);
    }

    @Override
    public void draw(Graphics g, boolean filled) {
        g.preDraw();
        GL.unbindTexture();
        if (filled) {
            throw new UnsupportedOperationException();
        }
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)this.pos1.x, (double)this.pos1.y);
        GL11.glVertex2d((double)this.pos2.x, (double)this.pos2.y);
        GL11.glEnd();
    }

    public void drawMulticolor(Graphics g, Color cPoint1, Color cPoint2) {
        g.preDraw();
        GL.unbindTexture();
        GL11.glBegin((int)1);
        GL.bind(cPoint1);
        GL11.glVertex2d((double)this.pos1.x, (double)this.pos1.y);
        GL.bind(cPoint2);
        GL11.glVertex2d((double)this.pos2.x, (double)this.pos2.y);
        GL11.glEnd();
    }

    @Override
    public Line interpolate(Line l, double d, Interpolate method) {
        return new Line(this.pos1.interpolate(l.pos1, d, method), this.pos2.interpolate(l.pos2, d, method));
    }
}

