/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.animfx;

import java.util.List;
import pl.shockah.SortedLinkedList;
import pl.shockah.glib.animfx.Animation;
import pl.shockah.glib.animfx.Fx;
import pl.shockah.glib.animfx.Interpolate;

public abstract class Timeline<T, F extends Fx<T>> {
    protected final List<F> fxs = new SortedLinkedList<F>();
    protected final Interpolate method;
    protected double maxTime = 0.0;

    Timeline() {
        this(Interpolate.Smoothstep.P1);
    }

    Timeline(Interpolate method) {
        this.method = method;
    }

    public T getState(double time) {
        return this.getState(time, false);
    }

    public T getState(double time, boolean looped) {
        if (this.fxs.isEmpty()) {
            throw new IllegalStateException("Blank timeline");
        }
        if (this.fxs.size() == 1) {
            return ((Fx)this.fxs.get(0)).getState(null, 0.0, ((Fx)this.fxs.get(0)).getMethod(this));
        }
        if (looped && time < ((Fx)this.fxs.get((int)0)).time) {
            return ((Fx)this.fxs.get(this.fxs.size() - 1)).getState((Fx)this.fxs.get(0), (this.getMaxTime() - time) / (this.getMaxTime() - this.maxTime + ((Fx)this.fxs.get((int)0)).time), ((Fx)this.fxs.get(this.fxs.size() - 1)).getMethod(this));
        }
        Fx prev = null;
        for (Fx fx : this.fxs) {
            if (fx.time >= time) {
                return prev == null ? fx.step : prev.getState(fx, (time - prev.time) / (fx.time - prev.time), prev.getMethod(this));
            }
            prev = fx;
        }
        if (looped && time > this.maxTime) {
            return prev.getState((Fx)this.fxs.get(0), (this.getMaxTime() - time) / (this.getMaxTime() - this.maxTime + ((Fx)this.fxs.get((int)0)).time), prev.getMethod(this));
        }
        return prev.getState(null, 0.0, prev.getMethod(this));
    }

    public T getState(Animation anim) {
        if (this.fxs.isEmpty()) {
            throw new IllegalStateException("Blank timeline");
        }
        if (this.fxs.size() == 1) {
            return ((Fx)this.fxs.get(0)).getState(null, 0.0, ((Fx)this.fxs.get(0)).getMethod(this));
        }
        if (anim.isLooped() && anim.getTime() < ((Fx)this.fxs.get((int)0)).time) {
            return ((Fx)this.fxs.get(this.fxs.size() - 1)).getState((Fx)this.fxs.get(0), (anim.getMaxTime() - anim.getTime()) / (anim.getMaxTime() - this.maxTime + ((Fx)this.fxs.get((int)0)).time), ((Fx)this.fxs.get(this.fxs.size() - 1)).getMethod(this));
        }
        Fx prev = null;
        for (Fx fx : this.fxs) {
            if (fx.time >= anim.getTime()) {
                return prev == null ? fx.step : prev.getState(fx, (anim.getTime() - prev.time) / (fx.time - prev.time), prev.getMethod(this));
            }
            prev = fx;
        }
        if (anim.isLooped() && anim.getTime() > this.maxTime) {
            return prev.getState((Fx)this.fxs.get(0), (anim.getMaxTime() - anim.getTime()) / (anim.getMaxTime() - this.maxTime + ((Fx)this.fxs.get((int)0)).time), prev.getMethod(this));
        }
        return prev.getState(null, 0.0, prev.getMethod(this));
    }

    public abstract void copyFirst(double var1);

    public abstract void copyLast(double var1);

    public abstract void copyFirst(double var1, Interpolate var3);

    public abstract void copyLast(double var1, Interpolate var3);

    public double getMaxTime() {
        return this.maxTime;
    }
}

