/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.Util;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.EntityBox;
import pl.shockah.ts.entities.EntityBoxGravity;
import pl.shockah.ts.entities.EntityPlayer;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EntityBoxFading
extends EntityBox {
    protected float fading = -1.0f;
    protected float alpha = 1.0f;

    @Override
    protected void onCreate() {
        super.onCreate();
        this.shape = new Rectangle(this.pos.x, this.pos.y, 24.0, 24.0);
    }

    @Override
    protected void onUpdate() {
        double mod = Game.me.time.getSpeed(this);
        if (mod == 0.0) {
            return;
        }
        if (this.fading == -1.0f && this.collidesAt(Util.getAllOf(Entities.getTypes(EntityPlayer.class, EntityBoxGravity.class), EntityCollidable.class), this.pos.x, this.pos.y - 1.0)) {
            this.fading = 10.0f;
        }
        if (this.fading > 0.0f) {
            this.fading = (float)((double)this.fading - 1.0 * mod);
        }
        if (this.fading <= 0.0f && this.fading > -1.0f) {
            this.alpha = (float)((double)this.alpha - (double)0.05f * mod);
            if (this.alpha <= 0.0f) {
                this.destroy();
            }
        }
    }

    @Override
    protected void onRegister() {
        new Renderable(this, this.baseDepth - 0.1){

            @Override
            protected void onRender(Graphics g) {
                Color c1 = Color.White.alpha(EntityBoxFading.this.alpha * 2.0f * WaterBlur.blurAlpha);
                Color c2 = Color.White.alpha(EntityBoxFading.this.alpha * WaterBlur.blurAlpha);
                Assets.ssBoxes.getImage(0).drawTextureMulticolor(g, EntityBoxFading.this.pos, c1, c1, c2, c2);
            }
        }.create();
        new Renderable(this, this.baseDepth - 0.2){

            @Override
            protected void onRender(Graphics g) {
                Color c1 = Color.White.alpha(EntityBoxFading.this.alpha * 2.0f * WaterBlur.blurAlpha);
                Color c2 = Color.White.alpha(EntityBoxFading.this.alpha * WaterBlur.blurAlpha);
                Assets.ssTileBorderThin.getImage(0).drawTextureMulticolor(g, EntityBoxFading.this.pos, c1, c1, c2, c2);
            }
        }.create();
    }
}

