/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.tanks;

import pl.shockah.glib.geom.Line;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.input.MInput;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.tanks.Assets;
import pl.shockah.tanks.EntityBullet;
import pl.shockah.tanks.EntityTank;
import pl.shockah.tanks.Game;

public class EntityTankPlayer
extends EntityTank {
    @Override
    protected void onUpdate() {
        double a = this.pos.direction(Game.getMousePos()) - this.rotation;
        double da = Vector2d.make(1.0, this.rotation2).deltaAngle(a);
        this.rotation2 += da * 0.05;
        Vector2d keys = new Vector2d();
        if (KInput.isDown(17)) {
            keys.y -= 1.0;
        }
        if (KInput.isDown(31)) {
            keys.y += 1.0;
        }
        if (KInput.isDown(30)) {
            keys.x -= 1.0;
        }
        if (KInput.isDown(32)) {
            keys.x += 1.0;
        }
        if (keys.x != 0.0 || keys.y != 0.0) {
            a = keys.direction();
            da = Vector2d.make(1.0, this.rotation).deltaAngle(a);
            this.rotation += da * 0.1;
            Vector2d move = Vector2d.make(4.0, this.rotation);
            this.pos.add(move);
            ++this.frame;
            if (this.frame < 0) {
                this.frame += this.frameMax;
            }
            if (this.frame >= this.frameMax) {
                this.frame -= this.frameMax;
            }
            this.tires.add(new EntityTank.TiresGhost(this.pos.copyMe(), this.rotation));
        }
        if (this.blockFire > 0) {
            --this.blockFire;
        }
        if (this.blockFire == 0 && MInput.isPressed(0)) {
            new EntityBullet(Vector2d.make(24.0, this.rotation2 + this.rotation)).create(this.pos.copyMe());
            this.blockFire = 60;
            Game.tremble += 50.0;
        }
        super.onUpdate();
    }

    @Override
    protected void onRegister() {
        super.onRegister();
        new Renderable(this, -0.5){

            @Override
            protected void onRender(Graphics g) {
                Vector2d v = Vector2d.make(EntityTankPlayer.this.pos.distance(Game.getMousePos()), EntityTankPlayer.this.rotation2 + EntityTankPlayer.this.rotation);
                double da = Math.abs(v.Add(EntityTankPlayer.this.pos).deltaAngle(Game.getMousePos()));
                new Line(EntityTankPlayer.this.pos.x, EntityTankPlayer.this.pos.y, EntityTankPlayer.this.pos.x + v.x, EntityTankPlayer.this.pos.y + v.y).drawMulticolor(g, Color.Black.alpha(0.0f), Color.Black);
                g.setColor(Color.White.alpha((float)(0.5 - da / 180.0)));
                g.draw((ITextureSupplier)Assets.sCrosshair, EntityTankPlayer.this.pos.x + v.x, EntityTankPlayer.this.pos.y + v.y);
                g.setColor(Color.White);
                g.draw((ITextureSupplier)Assets.sCrosshair, (IVector2)Game.getMousePos());
            }
        }.create();
    }
}

