/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import java.util.List;
import pl.shockah.SortedLinkedList;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.logic.standard.EntityBase;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.glib.logic.standard.RenderableDefault;

public abstract class EntityRenderable
extends EntityBase {
    protected final List<Renderable> renderables = new SortedLinkedList<Renderable>();
    private boolean listUsed = false;
    protected double baseDepth = 0.0;

    public EntityRenderable() {
    }

    public EntityRenderable(double depth) {
        this.baseDepth = depth;
    }

    @Override
    public final void create(IVector2 pos) {
        super.create(pos);
        this.register();
    }

    @Override
    public final void destroy() {
        this.listUsed = true;
        for (Renderable r : this.renderables) {
            r.destroy();
        }
        this.listUsed = false;
        this.renderables.clear();
        super.destroy();
    }

    protected final boolean isListUsed() {
        return this.listUsed;
    }

    public final void setDepth(double depth) {
        for (Renderable r : this.renderables) {
            r.setDepth(depth);
        }
    }

    public final void render(Graphics g) {
        this.onRender(g);
    }

    protected void onRender(Graphics g) {
    }

    private final void register() {
        this.onRegister();
    }

    protected void onRegister() {
        new RenderableDefault(this).create();
    }
}

