/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.animfx;

public abstract class Interpolate {
    public static final Interpolate Linear = new Interpolate(){

        @Override
        protected double interpolateBase(double d1, double d2, double d) {
            return d1 + (d2 - d1) * d;
        }
    };

    public int interpolate(int i1, int i2, double d) {
        return (int)this.interpolateBase(i1, i2, d);
    }

    public float interpolate(float f1, float f2, double d) {
        return (float)this.interpolateBase(f1, f2, d);
    }

    public double interpolate(double d1, double d2, double d) {
        return this.interpolateBase(d1, d2, d);
    }

    protected abstract double interpolateBase(double var1, double var3, double var5);

    public static final class Back {
        protected static final double s = 1.70158;
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * (t /= d) * t * (2.70158 * t - 1.70158) + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                t = t / d - 1.0;
                return c * (t * t * (2.70158 * t + 1.70158) + 1.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                double s = 1.70158;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * (t * t * (((s *= 1.525) + 1.0) * t - s)) + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * (((s *= (double)1.525f) + 1.0) * t + s) + 2.0) + b;
            }
        };
    }

    public static final class Bounce {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c - ((InterpolateEase)Out).ease(d - t, 0.0, c, d) + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d;
                if (d2 < 0.36363636363636365) {
                    return c * (7.5625 * t * t) + b;
                }
                if (t < 0.7272727272727273) {
                    return c * (7.5625 * (t -= 0.5454545454545454) * t + 0.75) + b;
                }
                if (t < 0.9090909090909091) {
                    return c * (7.5625 * (t -= 0.8181818181818182) * t + 0.9375) + b;
                }
                return c * (7.5625 * (t -= 0.9545454545454546) * t + 0.984375) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                if (t < d / 2.0) {
                    return ((InterpolateEase)In).ease(t * 2.0, 0.0, c, d) * 0.5 + b;
                }
                return ((InterpolateEase)Out).ease(t * 2.0 - d, 0.0, c, d) * 0.5 + c * 0.5 + b;
            }
        };
    }

    public static final class Circ {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return -c * (Math.sqrt(1.0 - (t /= d) * t) - 1.0) + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                t = t / d - 1.0;
                return c * Math.sqrt(1.0 - t * t) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return -c / 2.0 * (Math.sqrt(1.0 - t * t) - 1.0) + b;
                }
                return c / 2.0 * (Math.sqrt(1.0 - (t -= 2.0) * t) + 1.0) + b;
            }
        };
    }

    public static final class Cubic {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * (t /= d) * t * t + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                t = t / d - 1.0;
                return c * (t * t * t + 1.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * t * t * t + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * t + 2.0) + b;
            }
        };
    }

    public static final class Elastic {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d) == 1.0) {
                    return b + c;
                }
                double p = d * 0.3;
                double a = c;
                double s = p / 4.0;
                return a * Math.pow(2.0, -10.0 * t) * Math.sin((t * d - s) * (Math.PI * 2) / p) + c + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d) == 1.0) {
                    return b + c;
                }
                double p = d * 0.3;
                double a = c;
                double s = p / 4.0;
                return -(a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d / 2.0) == 2.0) {
                    return b + c;
                }
                double p = d * 0.44999999999999996;
                double a = c;
                double s = p / 4.0;
                if (t < 1.0) {
                    return -0.5 * (a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
                }
                return a * Math.pow(2.0, -10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p) * 0.5 + c + b;
            }
        };
    }

    public static final class Expo {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return t == 0.0 ? b : c * Math.pow(2.0, 10.0 * (t / d - 1.0)) + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return t == d ? b + c : c * (-Math.pow(2.0, -10.0 * t / d) + 1.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                if (t == 0.0) {
                    return b;
                }
                if (t == d) {
                    return b + c;
                }
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * Math.pow(2.0, 10.0 * (t - 1.0)) + b;
                }
                return c / 2.0 * (-Math.pow(2.0, -10.0 * (t -= 1.0)) + 2.0) + b;
            }
        };
    }

    private static abstract class InterpolateEase
    extends Interpolate {
        private InterpolateEase() {
        }

        @Override
        protected double interpolateBase(double d1, double d2, double d) {
            return this.ease(d, d1, d2 - d1, 1.0);
        }

        protected abstract double ease(double var1, double var3, double var5, double var7);
    }

    private static class InterpolateSmoothstep
    extends Interpolate {
        private InterpolateSmoothstep() {
        }

        @Override
        protected final double interpolateBase(double d1, double d2, double d) {
            return d1 + (d2 - d1) * this.smoothstepModifier(d);
        }

        protected double smoothstepModifier(double d) {
            return Math.pow(d, 2.0) * (3.0 - 2.0 * d);
        }

        /* synthetic */ InterpolateSmoothstep(InterpolateSmoothstep interpolateSmoothstep, InterpolateSmoothstep interpolateSmoothstep2) {
            this();
        }
    }

    public static final class Quad {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * (t /= d) * t + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return -c * (t /= d) * (t - 2.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * t * t + b;
                }
                return -c / 2.0 * ((t -= 1.0) * (t - 2.0) - 1.0) + b;
            }
        };
    }

    public static final class Quart {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * (t /= d) * t * t * t + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                t = t / d - 1.0;
                return -c * (t * t * t * t - 1.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * t * t * t * t + b;
                }
                return -c / 2.0 * ((t -= 2.0) * t * t * t - 2.0) + b;
            }
        };
    }

    public static final class Quint {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * (t /= d) * t * t * t * t + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                t = t / d - 1.0;
                return c * (t * t * t * t * t + 1.0) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                double d2;
                t /= d / 2.0;
                if (d2 < 1.0) {
                    return c / 2.0 * t * t * t * t * t + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * t * t * t + 2.0) + b;
            }
        };
    }

    public static final class Sine {
        public static final Interpolate In = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return -c * Math.cos(t / d * 1.5707963267948966) + c + b;
            }
        };
        public static final Interpolate Out = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return c * Math.sin(t / d * 1.5707963267948966) + b;
            }
        };
        public static final Interpolate InOut = new InterpolateEase(){

            @Override
            protected double ease(double t, double b, double c, double d) {
                return -c / 2.0 * (Math.cos(Math.PI * t / d) - 1.0) + b;
            }
        };
    }

    public static final class Smoothstep {
        public static final Interpolate P1 = new InterpolateSmoothstep();
        public static final Interpolate P2 = new InterpolateSmoothstep(){

            @Override
            protected double smoothstepModifier(double d) {
                return Math.pow(super.smoothstepModifier(d), 2.0);
            }
        };
        public static final Interpolate P3 = new InterpolateSmoothstep(){

            @Override
            protected double smoothstepModifier(double d) {
                return Math.pow(super.smoothstepModifier(d), 3.0);
            }
        };
    }
}

