/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.animfx;

import java.util.ArrayList;
import java.util.List;
import pl.shockah.glib.animfx.Timeline;

public class Animation {
    protected final List<String> tags = new ArrayList<String>();
    protected final List<Timeline<?, ?>> timelines = new ArrayList();
    protected double time = 0.0;
    protected double updateSpeed = 1.0;
    protected boolean looped = false;
    protected int loop = 0;

    public void update() {
        this.update(1.0);
    }

    public void update(double by) {
        this.time += this.updateSpeed;
        double maxTime = this.getMaxTime();
        if (this.time > maxTime) {
            if (this.looped) {
                this.time -= maxTime;
                ++this.loop;
            } else {
                this.time = maxTime;
            }
        } else if (this.time < 0.0) {
            if (this.looped) {
                this.time += maxTime;
                --this.loop;
            } else {
                this.time = 0.0;
            }
        }
    }

    public void reset() {
        this.time = 0.0;
        this.loop = 0;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public void add(Timeline<?, ?> timeline) {
        this.add(null, timeline);
    }

    public void add(String tag, Timeline<?, ?> timeline) {
        this.tags.add(tag);
        this.timelines.add(timeline);
    }

    public Timeline<?, ?> getTimeline(String tag) {
        return this.timelines.get(this.tags.indexOf(tag));
    }

    public Object getState(String tag) {
        return this.getTimeline(tag).getState(this);
    }

    public double getMaxTime() {
        double max = 0.0;
        for (Timeline<?, ?> timeline : this.timelines) {
            if (!(timeline.getMaxTime() > max)) continue;
            max = timeline.getMaxTime();
        }
        return max;
    }

    public boolean isFinished() {
        if (this.looped) {
            return false;
        }
        return this.time == this.getMaxTime();
    }

    public int getLoopNumber() {
        return this.loop;
    }

    public boolean isLooped() {
        return this.looped;
    }

    public Animation setLooped() {
        return this.setLooped(true);
    }

    public Animation setLooped(boolean looped) {
        this.looped = looped;
        return this;
    }

    public double getUpdateSpeed() {
        return this.updateSpeed;
    }

    public Animation resetUpdateSpeed() {
        return this.setUpdateSpeed(1.0);
    }

    public Animation setUpdateSpeed(double updateSpeed) {
        this.updateSpeed = updateSpeed;
        return this;
    }
}

