/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.json;

import java.util.Map;
import pl.shockah.StrBuffer;
import pl.shockah.json.JSONList;
import pl.shockah.json.JSONObject;

public class JSONPrinter {
    public String print(JSONObject j) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.print(sb, j);
        sb.append('}');
        return sb.toString();
    }

    public String print(JSONList<?> j) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        this.print(sb, j);
        sb.append(']');
        return sb.toString();
    }

    protected void print(StringBuilder sb, JSONObject j) {
        boolean f = true;
        for (Map.Entry<String, Object> entry : j.entries()) {
            Object j2;
            if (!f) {
                sb.append(",");
            }
            sb.append('\"');
            sb.append(this.escapeString(entry.getKey()));
            sb.append("\":");
            Object o = entry.getValue();
            if (o == null) {
                sb.append("null");
            } else if (o instanceof Boolean) {
                sb.append("" + o);
            } else if (o instanceof Number) {
                sb.append("" + o);
            } else if (o instanceof String) {
                sb.append(String.valueOf('\"') + this.escapeString("" + o) + '\"');
            } else if (o instanceof JSONObject) {
                j2 = (JSONObject)o;
                sb.append('{');
                this.print(sb, (JSONObject)j2);
                sb.append('}');
            } else if (o instanceof JSONList) {
                j2 = (JSONList)o;
                sb.append('[');
                this.print(sb, (JSONList<?>)j2);
                sb.append(']');
            }
            f = false;
        }
    }

    protected void print(StringBuilder sb, JSONList<?> j) {
        boolean f = true;
        for (Object o : j) {
            Object j2;
            if (!f) {
                sb.append(",");
            }
            if (o == null) {
                sb.append("null");
            } else if (o instanceof Boolean) {
                sb.append("" + o);
            } else if (o instanceof Number) {
                sb.append("" + o);
            } else if (o instanceof String) {
                sb.append(String.valueOf('\"') + this.escapeString("" + o) + '\"');
            } else if (o instanceof JSONObject) {
                j2 = (JSONObject)o;
                sb.append('{');
                this.print(sb, (JSONObject)j2);
                sb.append('}');
            } else if (o instanceof JSONList) {
                j2 = (JSONList)o;
                sb.append('[');
                this.print(sb, (JSONList<?>)j2);
                sb.append(']');
            }
            f = false;
        }
    }

    protected String escapeString(String s) {
        StrBuffer strb = new StrBuffer();
        strb.append(s);
        strb.setPos(0);
        while (!strb.atEnd()) {
            char c = strb.readChar();
            if (c == '\r') {
                strb.seek(-1);
                strb.delete(1);
                strb.append("\\r");
                continue;
            }
            if (c == '\n') {
                strb.seek(-1);
                strb.delete(1);
                strb.append("\\n");
                continue;
            }
            if (c == '\t') {
                strb.seek(-1);
                strb.delete(1);
                strb.append("\\t");
                continue;
            }
            if (c == '\"') {
                strb.seek(-1);
                strb.delete(1);
                strb.append("\\\"");
                continue;
            }
            if (c != '\\') continue;
            strb.seek(-1);
            strb.delete(1);
            strb.append("\\\\");
        }
        return strb.toString();
    }
}

