/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import pl.shockah.glib.LoadableProcessor;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureSupplier;

public class SpriteSheet
extends TextureSupplier {
    protected final Image[][] grid;
    protected final int gridX;
    protected final int gridY;
    protected final int spacingX;
    protected final int spacingY;

    public SpriteSheet(Image[][] grid) {
        super(null);
        this.grid = grid;
        this.spacingY = -1;
        this.spacingX = -1;
        this.gridY = -1;
        this.gridX = -1;
        int x = 0;
        while (x < grid.length) {
            int y = 0;
            while (y < grid[x].length) {
                grid[x][y].offset = this.offset;
                ++y;
            }
            ++x;
        }
    }

    public SpriteSheet(Texture tex, int grid) {
        this(tex, grid, grid);
    }

    public SpriteSheet(Texture tex, int gridX, int gridY) {
        this(tex, gridX, gridY, 0);
    }

    public SpriteSheet(Texture tex, int gridX, int gridY, int spacing) {
        this(tex, gridX, gridY, spacing, spacing);
    }

    public SpriteSheet(Texture tex, int gridX, int gridY, int spacingX, int spacingY) {
        super(tex);
        this.spacingX = spacingX;
        this.spacingY = spacingY;
        int w = tex.getWidth();
        int h = tex.getHeight();
        if (gridX < 0 || gridY < 0) {
            gridX = gridX < 0 ? w / -gridX : w;
            gridY = gridY < 0 ? h / -gridY : h;
        }
        this.gridX = gridX;
        this.gridY = gridY;
        this.grid = new Image[w / gridX][h / gridY];
        Image img = new Image(tex);
        int y = 0;
        int yy = 0;
        while (y < h) {
            int x = 0;
            int xx = 0;
            while (x < w) {
                this.grid[xx][yy] = img.part(x, y, gridX, gridY);
                this.grid[xx][yy].offset = this.offset;
                x += gridX + spacingX;
                ++xx;
            }
            y += gridY + spacingY;
            ++yy;
        }
    }

    public int getColumns() {
        return this.grid.length;
    }

    public int getRows() {
        return this.grid[0].length;
    }

    public int getCount() {
        return this.getColumns() * this.getRows();
    }

    public Image getImage(int x) {
        return this.getImage(x % this.grid.length, x / this.grid.length);
    }

    public Image getImage(int x, int y) {
        return this.grid[x][y];
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
        public String path() default "assets/spritesheets/<field.name>.png";

        public LoadableProcessor.AssetType type() default LoadableProcessor.AssetType.Internal;

        public int grid() default -1;

        public int gridX() default -1;

        public int gridY() default -1;

        public int framesX() default -1;

        public int framesY() default -1;

        public int spacingX() default 0;

        public int spacingY() default 0;

        public boolean toPremultiplied() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ZIPLoadable {
        public String path() default "assets/images/<field.name>.zip";

        public LoadableProcessor.AssetType type() default LoadableProcessor.AssetType.Internal;

        public boolean toPremultiplied() default false;
    }
}

