/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.polygon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.Line;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.polygon.BasicTriangulator;
import pl.shockah.glib.geom.polygon.ITriangulator;
import pl.shockah.glib.geom.polygon.NeatTriangulator;
import pl.shockah.glib.geom.polygon.Triangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;

public class Polygon
extends Shape {
    protected List<Vector2d> points = new ArrayList<Vector2d>();
    protected List<Triangle> triangles = new LinkedList<Triangle>();
    private boolean dirty = true;

    @Override
    public Shape copy() {
        return this.copyMe();
    }

    public Polygon copyMe() {
        Polygon p = this.getClass() == NoHoles.class ? new NoHoles() : new Polygon();
        for (Vector2d v : this.points) {
            p.addPoint(new Vector2d(v));
        }
        return p;
    }

    @Override
    public Rectangle getBoundingBox() {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int i = 0;
        while (i < this.points.size()) {
            Vector2d point = this.points.get(i);
            if (i == 0 || point.x < x1) {
                x1 = point.x;
            }
            if (i == 0 || point.y < y1) {
                y1 = point.y;
            }
            if (i == 0 || point.x > x2) {
                x2 = point.x;
            }
            if (i == 0 || point.y > y2) {
                y2 = point.y;
            }
            ++i;
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public Vector2d translate(double x, double y) {
        for (Vector2d v : this.points) {
            v.x += x;
            v.y += y;
        }
        this.dirty = true;
        return new Vector2d(x, y);
    }

    @Override
    public Vector2d translateTo(double x, double y) {
        Rectangle bb = this.getBoundingBox();
        return this.translate(x - bb.pos.x, y - bb.pos.y);
    }

    public Polygon addPoint(double x, double y) {
        return this.addPoint(new Vector2d(x, y));
    }

    public Polygon addPoint(Vector2d point) {
        this.points.add(point);
        this.dirty = true;
        return this;
    }

    public Vector2d removePoint(int index) {
        this.dirty = true;
        return this.points.remove(index);
    }

    public Vector2d getPoint(int index) {
        return this.points.get(index);
    }

    public Vector2d[] getPoints() {
        return this.points.toArray(new Vector2d[0]);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Line[] getLines() {
        return this.getLines(true);
    }

    public Line[] getLines(boolean closed) {
        Line[] ret = new Line[closed ? this.points.size() : this.points.size() - 1];
        int i = 0;
        while (i < (closed ? this.points.size() : this.points.size() - 1)) {
            ret[i] = new Line(this.points.get(i), this.points.get(i == this.points.size() - 1 ? 0 : i + 1));
            ++i;
        }
        return ret;
    }

    public ITriangulator getTriangulator() {
        return new NeatTriangulator();
    }

    public void updateTriangles() {
        if (!this.dirty) {
            return;
        }
        this.triangles.clear();
        ITriangulator tris = this.getTriangulator();
        Vector2d[] vector2dArray = this.getPoints();
        int n = vector2dArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vector2d v = vector2dArray[n2];
            tris.addPolyPoint(new Vector2d(v.x, v.y));
            ++n2;
        }
        tris.triangulate();
        int i = 0;
        while (i < tris.getTriangleCount()) {
            this.triangles.add(new Triangle(tris.getTrianglePoint(i, 0), tris.getTrianglePoint(i, 1), tris.getTrianglePoint(i, 2)));
            ++i;
        }
        this.dirty = false;
    }

    protected List<Triangle> getTriangles() {
        return Collections.unmodifiableList(this.triangles);
    }

    @Override
    public void draw(Graphics g, boolean filled) {
        g.preDraw();
        GL.unbindTexture();
        if (filled) {
            this.updateTriangles();
            GL11.glBegin((int)4);
            for (Triangle triangle : this.triangles) {
                Vector2d[] vector2dArray = triangle.getPoints();
                int n = vector2dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Vector2d v = vector2dArray[n2];
                    GL11.glVertex2d((double)v.x, (double)v.y);
                    ++n2;
                }
            }
            GL11.glEnd();
        } else {
            GL11.glBegin((int)3);
            int i = 0;
            while (i <= this.points.size()) {
                Vector2d v = this.points.get(i == this.points.size() ? 0 : i);
                GL11.glVertex2d((double)v.x, (double)v.y);
                ++i;
            }
            GL11.glEnd();
        }
    }

    public static class NoHoles
    extends Polygon {
        @Override
        public ITriangulator getTriangulator() {
            return new BasicTriangulator();
        }
    }
}

