/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.polygon;

import java.util.ArrayList;
import java.util.List;
import pl.shockah.glib.geom.polygon.ITriangulator;
import pl.shockah.glib.geom.vector.Vector2d;

public class BasicTriangulator
implements ITriangulator {
    private static final float EPSILON = 1.0E-10f;
    private List<Vector2d> poly = new ArrayList<Vector2d>();
    private List<Vector2d> tris = new ArrayList<Vector2d>();
    private boolean tried;

    @Override
    public void addPolyPoint(Vector2d point) {
        if (!this.poly.contains(point)) {
            this.poly.add(point);
        }
    }

    public int getPolyPointCount() {
        return this.poly.size();
    }

    public Vector2d getPolyPoint(int index) {
        return new Vector2d(this.poly.get((int)index).x, this.poly.get((int)index).y);
    }

    @Override
    public boolean triangulate() {
        this.tried = true;
        return this.process(this.poly, this.tris);
    }

    @Override
    public int getTriangleCount() {
        if (!this.tried) {
            throw new IllegalStateException("Call triangulate() before accessing triangles");
        }
        return this.tris.size() / 3;
    }

    @Override
    public Vector2d getTrianglePoint(int tri, int i) {
        if (!this.tried) {
            throw new IllegalStateException("Call triangulate() before accessing triangles");
        }
        return this.tris.get(tri * 3 + i);
    }

    private float area(List<Vector2d> contour) {
        int n = contour.size();
        float A = 0.0f;
        int p = n - 1;
        int q = 0;
        while (q < n) {
            Vector2d contourP = contour.get(p);
            Vector2d contourQ = contour.get(q);
            A = (float)((double)A + (contourP.x * contourQ.y - contourQ.x * contourP.y));
            p = q++;
        }
        return A * 0.5f;
    }

    private boolean insideTriangle(double Ax, double Ay, double Bx, double By, double Cx, double Cy, double Px, double Py) {
        double ax = Cx - Bx;
        double ay = Cy - By;
        double bx = Ax - Cx;
        double by = Ay - Cy;
        double cx = Bx - Ax;
        double cy = By - Ay;
        double apx = Px - Ax;
        double apy = Py - Ay;
        double bpx = Px - Bx;
        double bpy = Py - By;
        double cpx = Px - Cx;
        double cpy = Py - Cy;
        double aCROSSbp = ax * bpy - ay * bpx;
        double cCROSSap = cx * apy - cy * apx;
        double bCROSScp = bx * cpy - by * cpx;
        return aCROSSbp >= 0.0 && bCROSScp >= 0.0 && cCROSSap >= 0.0;
    }

    private boolean snip(List<Vector2d> contour, int u, int v, int w, int n, int[] V) {
        double Bx = contour.get((int)V[v]).x;
        double Ax = contour.get((int)V[u]).x;
        double Cy = contour.get((int)V[w]).y;
        double Ay = contour.get((int)V[u]).y;
        double By = contour.get((int)V[v]).y;
        double Cx = contour.get((int)V[w]).x;
        if ((double)1.0E-10f > (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax)) {
            return false;
        }
        int p = 0;
        while (p < n) {
            double Py;
            double Px;
            if (p != u && p != v && p != w && this.insideTriangle(Ax, Ay, Bx, By, Cx, Cy, Px = contour.get((int)V[p]).x, Py = contour.get((int)V[p]).y)) {
                return false;
            }
            ++p;
        }
        return true;
    }

    private boolean process(List<Vector2d> contour, List<Vector2d> result) {
        int v;
        result.clear();
        int n = contour.size();
        if (n < 3) {
            return false;
        }
        int[] V = new int[n];
        if (0.0f < this.area(contour)) {
            v = 0;
            while (v < n) {
                V[v] = v;
                ++v;
            }
        } else {
            v = 0;
            while (v < n) {
                V[v] = n - 1 - v;
                ++v;
            }
        }
        int nv = n;
        int count = 2 * nv;
        int v2 = nv - 1;
        while (nv > 2) {
            int w;
            if (count-- <= 0) {
                return false;
            }
            int u = v2;
            if (nv <= u) {
                u = 0;
            }
            if (nv <= (v2 = u + 1)) {
                v2 = 0;
            }
            if (nv <= (w = v2 + 1)) {
                w = 0;
            }
            if (!this.snip(contour, u, v2, w, nv, V)) continue;
            int a = V[u];
            int b = V[v2];
            int c = V[w];
            result.add(contour.get(a));
            result.add(contour.get(b));
            result.add(contour.get(c));
            int s = v2;
            int t = v2 + 1;
            while (t < nv) {
                V[s] = V[t];
                ++s;
                ++t;
            }
            count = 2 * --nv;
        }
        return true;
    }

    @Override
    public void startHole() {
    }
}

