/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pl.shockah.BinBuffer;
import pl.shockah.BinBufferInputStream;
import pl.shockah.FieldObj;
import pl.shockah.FileLine;
import pl.shockah.Pair;
import pl.shockah.glib.AssetLoader;
import pl.shockah.glib.ILoadableAnnotationHandler;
import pl.shockah.glib.gl.Shader;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.gl.font.TrueTypeFont;
import pl.shockah.glib.gl.tex.Atlas;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.gl.tex.SVGTextureLoader;
import pl.shockah.glib.gl.tex.SpriteSheet;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureLoader;
import pl.shockah.json.JSONObject;
import pl.shockah.json.JSONParser;

public final class LoadableProcessor {
    public static List<LoadAction<?>> process(Class<?> cls) {
        return LoadableProcessor.process(cls, null, null);
    }

    public static List<LoadAction<?>> process(Class<?> cls, ILoadableAnnotationHandler handler) {
        return LoadableProcessor.process(cls, null, handler);
    }

    public static List<LoadAction<?>> process(Object o) {
        return LoadableProcessor.process(o.getClass(), o, null);
    }

    public static List<LoadAction<?>> process(Object o, ILoadableAnnotationHandler handler) {
        return LoadableProcessor.process(o.getClass(), o, handler);
    }

    private static List<LoadAction<?>> process(Class<?> cls, Object o, ILoadableAnnotationHandler handler) {
        LinkedList ret = new LinkedList();
        AccessibleObject[] accessibleObjectArray = cls.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Font.Loadable loadable;
            Method mtd = accessibleObjectArray[n2];
            Font.Loadables loadables = mtd.getAnnotation(Font.Loadables.class);
            if (loadables != null) {
                Font.Loadable[] loadableArray = loadables.value();
                int n3 = loadableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    loadable = loadableArray[n4];
                    ret.add(new FontLoadAction(null, loadable));
                    ++n4;
                }
            }
            if ((loadable = mtd.getAnnotation(Font.Loadable.class)) != null) {
                ret.add(new FontLoadAction(null, loadable));
            }
            ++n2;
        }
        accessibleObjectArray = cls.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            TrueTypeFont.Loadable ttfLoadable;
            Atlas.Loadable atlasLoadable;
            Shader.Loadable shaderLoadable;
            SpriteSheet.ZIPLoadable zipSSLoadable;
            SpriteSheet.Loadable sheetLoadable;
            Image.Loadable imageLoadable;
            AccessibleObject fld = accessibleObjectArray[n2];
            TextureLoader.IntOptions optints = ((Field)fld).getAnnotation(TextureLoader.IntOptions.class);
            if (optints == null) {
                final TextureLoader.IntOption optint = ((Field)fld).getAnnotation(TextureLoader.IntOption.class);
                if (optint != null) {
                    optints = new TextureLoader.IntOptions(){

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return TextureLoader.IntOptions.class;
                        }

                        @Override
                        public TextureLoader.IntOption[] value() {
                            return new TextureLoader.IntOption[]{optint};
                        }
                    };
                } else {
                    final SVGTextureLoader.Options svgopt = ((Field)fld).getAnnotation(SVGTextureLoader.Options.class);
                    if (svgopt != null) {
                        optints = new TextureLoader.IntOptions(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return TextureLoader.IntOptions.class;
                            }

                            @Override
                            public TextureLoader.IntOption[] value() {
                                LinkedList<TextureLoader.IntOption> list = new LinkedList<TextureLoader.IntOption>();
                                if (svgopt.width() > 0) {
                                    list.add(new TextureLoader.IntOption(){

                                        @Override
                                        public Class<? extends Annotation> annotationType() {
                                            return TextureLoader.IntOption.class;
                                        }

                                        @Override
                                        public String option() {
                                            return "width";
                                        }

                                        @Override
                                        public int value() {
                                            return svgopt.width();
                                        }
                                    });
                                }
                                if (svgopt.height() > 0) {
                                    list.add(new TextureLoader.IntOption(){

                                        @Override
                                        public Class<? extends Annotation> annotationType() {
                                            return TextureLoader.IntOption.class;
                                        }

                                        @Override
                                        public String option() {
                                            return "height";
                                        }

                                        @Override
                                        public int value() {
                                            return svgopt.height();
                                        }
                                    });
                                }
                                return list.toArray(new TextureLoader.IntOption[0]);
                            }
                        };
                    }
                }
            }
            if ((imageLoadable = ((Field)fld).getAnnotation(Image.Loadable.class)) != null) {
                ret.add(new ImageLoadAction(new FieldObj((Field)fld, o), imageLoadable, optints));
            }
            if ((sheetLoadable = ((Field)fld).getAnnotation(SpriteSheet.Loadable.class)) != null) {
                ret.add(new SpriteSheetLoadAction(new FieldObj((Field)fld, o), sheetLoadable, optints));
            }
            if ((zipSSLoadable = ((Field)fld).getAnnotation(SpriteSheet.ZIPLoadable.class)) != null) {
                ret.add(new ZIPSpriteSheetLoadAction(new FieldObj((Field)fld, o), zipSSLoadable, optints));
            }
            if ((shaderLoadable = ((Field)fld).getAnnotation(Shader.Loadable.class)) != null) {
                ret.add(new ShaderLoadAction(new FieldObj((Field)fld, o), shaderLoadable));
            }
            if ((atlasLoadable = ((Field)fld).getAnnotation(Atlas.Loadable.class)) != null) {
                ret.add(new AtlasLoadAction(new FieldObj((Field)fld, o), atlasLoadable, optints));
            }
            if ((ttfLoadable = ((Field)fld).getAnnotation(TrueTypeFont.Loadable.class)) != null) {
                ret.add(new TrueTypeFontLoadAction(new FieldObj((Field)fld, o), ttfLoadable));
            }
            if (handler != null) {
                handler.handle(ret, (Field)fld, o);
            }
            ++n2;
        }
        return ret;
    }

    public static enum AssetType {
        Internal,
        File;

    }

    public static class AtlasLoadAction
    extends LoadAction<Atlas.Loadable> {
        protected final TextureLoader.IntOptions optints;

        public AtlasLoadAction(FieldObj field, Atlas.Loadable loadable, TextureLoader.IntOptions optints) {
            super(field, loadable);
            this.optints = optints;
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                TextureLoader.clearOptionsGlobal();
                if (this.optints != null) {
                    TextureLoader.IntOption[] intOptionArray = this.optints.value();
                    int n = intOptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextureLoader.IntOption optint = intOptionArray[n2];
                        TextureLoader.setOptionGlobal(optint.option(), optint.value());
                        ++n2;
                    }
                }
                if (((Atlas.Loadable)this.loadable).toPremultiplied()) {
                    TextureLoader.setOptionGlobal("toPremultiplied", true);
                }
                Texture tex = null;
                JSONObject j = null;
                String path = this.handlePath(((Atlas.Loadable)this.loadable).path());
                switch (((Atlas.Loadable)this.loadable).type()) {
                    case File: {
                        File f = new File(path);
                        String ext = f.getName().substring(f.getName().lastIndexOf(46));
                        tex = Texture.load(f);
                        j = new JSONParser().parseObject(FileLine.readString(new File(f.getParentFile(), String.valueOf(f.getName().substring(0, f.getName().length() - ext.length())) + ".json")));
                        break;
                    }
                    case Internal: {
                        String ext = path.substring(path.lastIndexOf(46));
                        tex = Texture.load(path);
                        j = new JSONParser().parseObject(FileLine.readString(this.getClass().getClassLoader().getResourceAsStream(String.valueOf(path.substring(0, path.length() - ext.length())) + ".json")));
                    }
                }
                Atlas a = new Atlas(tex);
                a.fillFromJSON(j);
                this.field.set(a);
                TextureLoader.clearOptionsGlobal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class FontLoadAction
    extends LoadAction<Font.Loadable> {
        public FontLoadAction(FieldObj field, Font.Loadable loadable) {
            super(field, loadable);
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                switch (((Font.Loadable)this.loadable).type()) {
                    case File: {
                        Font.registerNew(new File(((Font.Loadable)this.loadable).path()));
                        break;
                    }
                    case Internal: {
                        Font.registerNew(((Font.Loadable)this.loadable).path());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class ImageLoadAction
    extends LoadAction<Image.Loadable> {
        protected final TextureLoader.IntOptions optints;

        public ImageLoadAction(FieldObj field, Image.Loadable loadable, TextureLoader.IntOptions optints) {
            super(field, loadable);
            this.optints = optints;
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                TextureLoader.clearOptionsGlobal();
                if (this.optints != null) {
                    TextureLoader.IntOption[] intOptionArray = this.optints.value();
                    int n = intOptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextureLoader.IntOption optint = intOptionArray[n2];
                        TextureLoader.setOptionGlobal(optint.option(), optint.value());
                        ++n2;
                    }
                }
                if (((Image.Loadable)this.loadable).toPremultiplied()) {
                    TextureLoader.setOptionGlobal("toPremultiplied", true);
                }
                Texture tex = null;
                String path = this.handlePath(((Image.Loadable)this.loadable).path());
                switch (((Image.Loadable)this.loadable).type()) {
                    case File: {
                        tex = Texture.load(new File(path));
                        break;
                    }
                    case Internal: {
                        tex = Texture.load(path);
                    }
                }
                this.field.set(new Image(tex));
                TextureLoader.clearOptionsGlobal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static abstract class LoadAction<T extends Annotation> {
        protected final FieldObj field;
        protected final T loadable;

        public LoadAction(FieldObj field, T loadable) {
            this.field = field;
            this.loadable = loadable;
        }

        protected String handlePath(String path) {
            path = path.replace("<field.name>", this.field.getField().getName());
            return path;
        }

        public abstract boolean load(AssetLoader var1);
    }

    public static class ShaderLoadAction
    extends LoadAction<Shader.Loadable> {
        public ShaderLoadAction(FieldObj field, Shader.Loadable loadable) {
            super(field, loadable);
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                Shader sdr = null;
                String path = this.handlePath(((Shader.Loadable)this.loadable).path());
                switch (((Shader.Loadable)this.loadable).type()) {
                    case File: {
                        sdr = Shader.createFromFile(new File(path), ((Shader.Loadable)this.loadable).mixTexturing(), ((Shader.Loadable)this.loadable).embedConsts());
                        break;
                    }
                    case Internal: {
                        sdr = Shader.createFromPath(path, ((Shader.Loadable)this.loadable).mixTexturing(), ((Shader.Loadable)this.loadable).embedConsts());
                    }
                }
                if (sdr != null) {
                    sdr.setMixTexturing(((Shader.Loadable)this.loadable).mixTexturing());
                }
                this.field.set(sdr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class SpriteSheetLoadAction
    extends LoadAction<SpriteSheet.Loadable> {
        protected final TextureLoader.IntOptions optints;

        public SpriteSheetLoadAction(FieldObj field, SpriteSheet.Loadable loadable, TextureLoader.IntOptions optints) {
            super(field, loadable);
            this.optints = optints;
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                TextureLoader.clearOptionsGlobal();
                if (this.optints != null) {
                    TextureLoader.IntOption[] intOptionArray = this.optints.value();
                    int n = intOptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextureLoader.IntOption optint = intOptionArray[n2];
                        TextureLoader.setOptionGlobal(optint.option(), optint.value());
                        ++n2;
                    }
                }
                if (((SpriteSheet.Loadable)this.loadable).toPremultiplied()) {
                    TextureLoader.setOptionGlobal("toPremultiplied", true);
                }
                int gridX = ((SpriteSheet.Loadable)this.loadable).gridX();
                int gridY = ((SpriteSheet.Loadable)this.loadable).gridY();
                int grid = ((SpriteSheet.Loadable)this.loadable).grid();
                if (gridX == -1 && gridY != -1) {
                    gridX = gridY;
                }
                if (gridX != -1 && gridY == -1) {
                    gridY = gridX;
                }
                if (gridX == -1 && gridY == -1 && grid != -1) {
                    gridX = grid;
                    gridY = grid;
                }
                if (gridX == -1 || gridY == -1) {
                    int framesX = ((SpriteSheet.Loadable)this.loadable).framesX();
                    int framesY = ((SpriteSheet.Loadable)this.loadable).framesY();
                    if (framesX != -1 || framesY != -1) {
                        gridX = -framesX;
                        gridY = -framesY;
                    } else {
                        throw new IllegalArgumentException("Grid/frames have to be specified (" + this.field.getObject() + ")");
                    }
                }
                Texture tex = null;
                String path = this.handlePath(((SpriteSheet.Loadable)this.loadable).path());
                switch (((SpriteSheet.Loadable)this.loadable).type()) {
                    case File: {
                        tex = Texture.load(new File(path));
                        break;
                    }
                    case Internal: {
                        tex = Texture.load(path);
                    }
                }
                this.field.set(new SpriteSheet(tex, gridX, gridY, ((SpriteSheet.Loadable)this.loadable).spacingX(), ((SpriteSheet.Loadable)this.loadable).spacingY()));
                TextureLoader.clearOptionsGlobal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class TrueTypeFontLoadAction
    extends LoadAction<TrueTypeFont.Loadable> {
        public TrueTypeFontLoadAction(FieldObj field, TrueTypeFont.Loadable loadable) {
            super(field, loadable);
        }

        @Override
        public boolean load(AssetLoader al) {
            try {
                this.field.set(new TrueTypeFont(((TrueTypeFont.Loadable)this.loadable).name(), ((TrueTypeFont.Loadable)this.loadable).size(), ((TrueTypeFont.Loadable)this.loadable).bold(), ((TrueTypeFont.Loadable)this.loadable).italic(), ((TrueTypeFont.Loadable)this.loadable).antiAlias(), ((TrueTypeFont.Loadable)this.loadable).additionalChars()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class ZIPSpriteSheetLoadAction
    extends LoadAction<SpriteSheet.ZIPLoadable> {
        protected final TextureLoader.IntOptions optints;
        protected boolean loaded = false;
        protected int count = 0;
        protected int total = 0;
        protected List<Pair<String, BinBuffer>> buffers = new LinkedList<Pair<String, BinBuffer>>();
        protected List<Pair<Integer, Image>> images = new LinkedList<Pair<Integer, Image>>();

        public ZIPSpriteSheetLoadAction(FieldObj field, SpriteSheet.ZIPLoadable loadable, TextureLoader.IntOptions optints) {
            super(field, loadable);
            this.optints = optints;
        }

        @Override
        public boolean load(AssetLoader al) {
            block15: {
                ZipEntry ze;
                if (this.loaded) break block15;
                ZipInputStream zis = null;
                String path = this.handlePath(((SpriteSheet.ZIPLoadable)this.loadable).path());
                switch (((SpriteSheet.ZIPLoadable)this.loadable).type()) {
                    case File: {
                        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(path)));
                        break;
                    }
                    case Internal: {
                        zis = new ZipInputStream(new BufferedInputStream(Texture.class.getClassLoader().getResourceAsStream(path)));
                    }
                }
                ZipInputStream zis2 = zis;
                while ((ze = zis.getNextEntry()) != null) {
                    int b;
                    BinBuffer binb = new BinBuffer();
                    while ((b = zis2.read()) != -1) {
                        binb.writeByte(b);
                    }
                    binb.setPos(0);
                    this.buffers.add(new Pair<String, BinBuffer>(ze.getName(), binb));
                    ++this.total;
                    this.loaded = true;
                }
                zis.close();
                return false;
            }
            try {
                if (!this.buffers.isEmpty()) {
                    al.setCurrentStatus(0.3 + 0.7 / (double)this.total * (double)this.count);
                    Pair<String, BinBuffer> pair = this.buffers.remove(0);
                    TextureLoader.clearOptionsGlobal();
                    if (this.optints != null) {
                        TextureLoader.IntOption[] intOptionArray = this.optints.value();
                        int n = intOptionArray.length;
                        int zis2 = 0;
                        while (zis2 < n) {
                            TextureLoader.IntOption optint = intOptionArray[zis2];
                            TextureLoader.setOptionGlobal(optint.option(), optint.value());
                            ++zis2;
                        }
                    }
                    if (((SpriteSheet.ZIPLoadable)this.loadable).toPremultiplied()) {
                        TextureLoader.setOptionGlobal("toPremultiplied", true);
                    }
                    String[] spl = pair.get1().split("\\.");
                    BinBufferInputStream binbis = new BinBufferInputStream(pair.get2());
                    this.images.add(new Pair<Integer, Image>(Integer.parseInt(spl[0]), new Image(Texture.load(binbis, spl[spl.length - 1].toUpperCase()))));
                    ++this.count;
                }
                if (this.buffers.isEmpty()) {
                    Image[][] ar = new Image[this.images.size()][1];
                    for (Pair<Integer, Image> pair : this.images) {
                        ar[pair.get1().intValue()][0] = pair.get2();
                    }
                    this.field.set(new SpriteSheet(ar));
                    TextureLoader.clearOptionsGlobal();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
    }
}

