/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.menu;

import pl.shockah.Math2;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.font.ETextAlign;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.gl.font.TextHelper;
import pl.shockah.glib.gl.tex.Atlas;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.input.MInput;
import pl.shockah.glib.state.State;
import pl.shockah.ts.Assets;
import pl.shockah.ts.menu.MenuElement;
import pl.shockah.ts.menu.MenuSet;

public class MenuElButton
extends MenuElement {
    public static final Atlas atlas = Assets.aFrameText;
    protected String text = "";
    protected Runnable action = null;
    protected float selectedAlpha = 0.0f;

    public MenuElButton setText(String text) {
        this.text = text;
        return this;
    }

    public MenuElButton setAction(Runnable action) {
        this.action = action;
        return this;
    }

    @Override
    protected void create(MenuSet menu, boolean selected) {
        this.selectedAlpha = selected ? 1.0f : 0.0f;
    }

    @Override
    protected boolean update(MenuSet menu, Rectangle rect, Font font, boolean selected) {
        this.selectedAlpha = Math2.limit(this.selectedAlpha + 0.1f * (float)(selected ? 1 : -1), 0.0f, 1.0f);
        if (selected && KInput.isPressed(28) && this.action != null) {
            this.action.run();
        }
        if (MInput.inRectangle(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y))) {
            if (selected && MInput.isPressed(0) && this.action != null) {
                this.action.run();
            }
            return !MInput.getDeltaPos().equals(new Vector2i());
        }
        return false;
    }

    @Override
    protected void render(MenuSet menu, Graphics g, Rectangle rect, Font font, boolean selected) {
        g.setColor(Color.Black.alpha(0.5f));
        g.draw(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y));
        g.setColor(Color.Black.alpha(0.5f * this.selectedAlpha));
        g.draw(new Rectangle(0.0, rect.pos.y, State.get().getDisplaySize().x, rect.size.y));
        g.setColor(Color.Black);
        int yy = -1;
        while (yy <= 1) {
            int xx = -1;
            while (xx <= 1) {
                TextHelper.draw(g, font, rect.pos.Add(xx, yy).add(rect.size.Div(2.0)), (CharSequence)this.text, ETextAlign.MiddleCenter);
                xx += 2;
            }
            yy += 2;
        }
        g.setColor(Color.White);
        TextHelper.draw(g, font, rect.pos.Add(rect.size.Div(2.0)), (CharSequence)this.text, ETextAlign.MiddleCenter);
    }
}

