/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities.effects;

import pl.shockah.glib.geom.Ellipse;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.EntityRenderable;

public class EffectJumpRipple
extends EntityRenderable {
    protected final EOrientation orientation;
    protected Vector2d scale;
    protected float alpha = 1.0f;

    public EffectJumpRipple(EOrientation orientation) {
        this.baseDepth = -5.0;
        this.orientation = orientation;
    }

    @Override
    protected void onCreate() {
        this.scale = this.orientation.getScale();
    }

    @Override
    protected void onUpdate() {
        this.scale.add(this.orientation.getScale().scale(0.08333333333333333));
        this.alpha -= 0.1f;
        if (this.alpha <= 0.0f) {
            this.destroy();
        }
    }

    @Override
    protected void onRender(Graphics g) {
        g.setColor(Color.White.alpha(this.alpha));
        g.draw(new Ellipse(this.pos, this.scale));
    }

    public static enum EOrientation {
        Horizontal(new Vector2d(6.0, 3.0)),
        Vertical(new Vector2d(3.0, 6.0));

        private final Vector2d scale;

        private EOrientation(Vector2d scale) {
            this.scale = scale;
        }

        public Vector2d getScale() {
            return new Vector2d(this.scale);
        }
    }
}

