/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;
import pl.shockah.ts.entities.EntityWall;
import pl.shockah.ts.entities.waterblur.IWaterBlur;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;
import pl.shockah.ts.gameplay.ITimeAffected;

public class EntitySpikes
extends EntityCollidable
implements IWaterBlur,
ITimeAffected {
    protected boolean[] sides = new boolean[4];
    protected int frame = 0;
    protected float rotateTimer = -1.0f;
    protected double rotating = 0.0;
    protected double angle = 0.0;

    public EntitySpikes() {
        this.baseDepth = 0.1;
    }

    @Override
    protected void onCreate() {
        this.shape = new Rectangle(this.pos.x, this.pos.y, 24.0, 24.0);
    }

    @Override
    protected void onFirstUpdate() {
        int i = 0;
        while (i < this.sides.length) {
            this.sides[i] = false;
            ++i;
        }
        for (EntityWall wall : Entities.getType(EntityWall.class)) {
            if (this.isSide(0, -1, wall)) {
                this.sides[0] = true;
            }
            if (this.isSide(0, 1, wall)) {
                this.sides[1] = true;
            }
            if (this.isSide(-1, 0, wall)) {
                this.sides[2] = true;
            }
            if (!this.isSide(1, 0, wall)) continue;
            this.sides[3] = true;
        }
        i = 0;
        while (i < 4) {
            this.frame += this.sides[i] ? 1 << i : 0;
            ++i;
        }
        if (this.frame == 0 || this.frame == 3 || this.frame == 12 || this.frame == 15) {
            this.rotateTimer = Main.rand.nextInt(120);
        }
    }

    protected boolean isSide(int x, int y, EntityWall wall) {
        return wall.pos.x == this.pos.x + (double)(x * 24) && wall.pos.y == this.pos.y + (double)(y * 24);
    }

    @Override
    protected void onUpdate() {
        double mod = Game.me.time.getSpeed(this);
        if (mod == 0.0) {
            return;
        }
        if (this.rotateTimer > 0.0f) {
            this.rotateTimer = (float)((double)this.rotateTimer - 1.0 * mod);
            if (this.rotateTimer <= 0.0f && this.rotateTimer > -1.0f) {
                this.rotating = 3 * (Main.rand.nextBoolean() ? 1 : -1);
                this.rotateTimer = 120 + Main.rand.nextInt(120);
            }
        }
        if (this.rotating != 0.0) {
            this.angle += this.rotating;
            if (this.angle >= 360.0) {
                this.angle -= 360.0;
            }
            if (this.angle < 0.0) {
                this.angle += 360.0;
            }
            if (this.angle % 90.0 == 0.0) {
                this.rotating = 0.0;
            }
        }
    }

    @Override
    protected void onRender(Graphics g) {
        g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
        Assets.ssSpikes.getImage((int)this.frame).rotation.angle = this.angle;
        g.draw((ITextureSupplier)Assets.ssSpikes.getImage(this.frame), this.pos.x, this.pos.y);
    }

    @Override
    public boolean affectedSlow() {
        return true;
    }

    @Override
    public boolean affectedStop() {
        return true;
    }
}

