/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.particle;

import java.util.ArrayList;
import java.util.List;
import pl.shockah.glib.gl.BlendMode;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.particle.Particle;

public class ParticleSystem
extends EntityRenderable {
    protected final BlendMode blendMode;
    protected List<Particle> particles = new ArrayList<Particle>();

    public ParticleSystem() {
        this(BlendMode.Add);
    }

    public ParticleSystem(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    protected void onUpdate() {
        int i = 0;
        while (i < this.particles.size()) {
            Particle p = this.particles.get(i);
            p.update();
            if (p.dead) {
                this.particles.remove(i--);
            }
            ++i;
        }
    }

    @Override
    protected void onRender(Graphics g) {
        this.blendMode.apply();
        for (Particle p : this.particles) {
            p.render(g);
        }
        Graphics.getDefaultBlendMode().apply();
    }
}

