/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import pl.shockah.BinBuffer;
import pl.shockah.BinBufferInputStream;
import pl.shockah.BinBufferOutputStream;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureLoader;

public class SVGTextureLoader
extends TextureLoader {
    public SVGTextureLoader() {
        super("SVG");
    }

    @Override
    public Texture load(InputStream is) throws IOException {
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        SVGDocument doc = df.createSVGDocument(null, is);
        TranscoderInput ti = new TranscoderInput((Document)doc);
        BinBuffer binb = new BinBuffer();
        TranscoderOutput to = new TranscoderOutput((OutputStream)new BinBufferOutputStream(binb));
        PNGTranscoder trans = new PNGTranscoder();
        if (this.settings.containsKey("width")) {
            trans.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)new Float(((Integer)this.settings.get("width")).intValue()));
        }
        if (this.settings.containsKey("height")) {
            trans.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)new Float(((Integer)this.settings.get("height")).intValue()));
        }
        try {
            trans.transcode(ti, to);
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
        binb.setPos(0);
        return Texture.load(new BinBufferInputStream(binb), "PNG");
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Options {
        public int width() default -1;

        public int height() default -1;
    }
}

