/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.LoadableProcessor;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureSupplier;

public class Image
extends TextureSupplier {
    public Rotation rotation = new Rotation();

    public Image(Texture tex) {
        super(tex);
    }

    @Override
    protected void preDraw(Graphics g) {
        if (this.rotation.angle != 0.0) {
            while (this.rotation.angle >= 360.0) {
                this.rotation.angle -= 360.0;
            }
            while (this.rotation.angle < 0.0) {
                this.rotation.angle += 360.0;
            }
            GL11.glTranslated((double)(this.rotation.center.x * this.scale.x), (double)(this.rotation.center.y * this.scale.y), (double)0.0);
            GL11.glRotated((double)(-this.rotation.angle), (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-this.rotation.center.x * this.scale.x), (double)(-this.rotation.center.y * this.scale.y), (double)0.0);
        }
    }

    @Override
    protected void postDraw(Graphics g) {
        if (this.rotation.angle != 0.0) {
            GL11.glTranslated((double)(this.rotation.center.x * this.scale.x), (double)(this.rotation.center.y * this.scale.y), (double)0.0);
            GL11.glRotated((double)this.rotation.angle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-this.rotation.center.x * this.scale.x), (double)(-this.rotation.center.y * this.scale.y), (double)0.0);
        }
    }

    public Image part(int x, int y, int w, int h) {
        Rectangle rect = this.getTextureRect();
        Image2 img = new Image2(this.getTexture(), (int)(rect.pos.x + (double)x), (int)(rect.pos.y + (double)y), w, h);
        img.offset.set(this.offset);
        img.rotation.angle = this.rotation.angle;
        img.rotation.center.set(this.rotation.center);
        return img;
    }

    public Image part(Rectangle rect) {
        return this.part((int)rect.pos.x, (int)rect.pos.y, (int)rect.size.x, (int)rect.size.y);
    }

    public void center() {
        this.offset = this.getTextureRect().size.div(2.0);
        this.rotation.center();
    }

    protected static class Image2
    extends Image {
        protected final int x;
        protected final int y;
        protected final int w;
        protected final int h;

        public Image2(Texture tex, int x, int y, int w, int h) {
            super(tex);
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public Rectangle getTextureRect() {
            return new Rectangle(this.x, this.y, this.w, this.h);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
        public String path() default "assets/images/<field.name>.png";

        public LoadableProcessor.AssetType type() default LoadableProcessor.AssetType.Internal;

        public boolean toPremultiplied() default false;
    }

    public class Rotation {
        public Vector2d center = new Vector2d();
        public double angle = 0.0;

        public void center() {
            this.center = Image.this.getTextureRect().size.div(2.0);
        }
    }
}

