/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl;

import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.GraphicsSurface;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.gl.tex.Texture;

public class Surface {
    private final int surId;
    private boolean disposed = false;
    public final Image image;
    public final Graphics g;

    public static Surface create(IVector2 v) {
        return Surface.create(v.Xi(), v.Yi());
    }

    public static Surface create(int w, int h) {
        int surId = EXTFramebufferObject.glGenFramebuffersEXT();
        int texId = GL11.glGenTextures();
        int rbo = EXTFramebufferObject.glGenRenderbuffersEXT();
        Texture tex = new Texture(texId, w, h);
        Vector2i fold = Texture.get2Fold(w, h);
        Surface sur = new Surface(surId, new Image(tex));
        GL.unbindTexture();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)surId);
        GL11.glBindTexture((int)3553, (int)texId);
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)fold.x, (int)fold.y, (int)0, (int)6408, (int)5121, null);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)texId, (int)0);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)rbo);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)34041, (int)fold.x, (int)fold.y);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)rbo);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36128, (int)36161, (int)rbo);
        GL11.glBindTexture((int)3553, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        sur.graphics().clear();
        return sur;
    }

    public Surface(int surId, Image image) {
        this.surId = surId;
        this.image = image;
        this.g = new GraphicsSurface(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Surface)) {
            return false;
        }
        Surface sur = (Surface)other;
        return sur.surId == this.surId;
    }

    public int getID() {
        if (this.disposed) {
            throw new IllegalStateException("Surface already disposed");
        }
        return this.surId;
    }

    public Image image() {
        if (this.disposed) {
            throw new IllegalStateException("Surface already disposed");
        }
        return this.image;
    }

    public Graphics graphics() {
        if (this.disposed) {
            throw new IllegalStateException("Surface already disposed");
        }
        return this.g;
    }

    public void dispose() {
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.surId);
        this.image.dispose();
        this.disposed = true;
    }
}

