/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib;

import java.util.Arrays;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import pl.shockah.glib.BestDisplayModeComparator;
import pl.shockah.glib.Debug;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.input.MInput;
import pl.shockah.glib.logic.IGame;
import pl.shockah.glib.state.State;

public final class Gamelib {
    public static DisplayMode originalDisplayMode;
    public static final Capabilities capabilities;
    public static IGame game;
    public static DisplayMode cachedDisplayMode;
    protected static boolean cachedFullscreen;
    protected static boolean isRunning;

    static {
        capabilities = new Capabilities();
        cachedDisplayMode = null;
        cachedFullscreen = false;
        isRunning = false;
    }

    public static void setDisplayMode(Vector2i v) {
        Gamelib.setDisplayMode(v.x, v.y);
    }

    public static void setDisplayMode(int width, int height) {
        Gamelib.setDisplayMode(width, height, cachedFullscreen);
    }

    public static void setDisplayMode(Vector2i v, boolean fullscreen) {
        Gamelib.setDisplayMode(v.x, v.y, fullscreen);
    }

    public static void setDisplayMode(int width, int height, boolean fullscreen) {
        if (cachedDisplayMode == null) {
            cachedDisplayMode = originalDisplayMode;
        }
        if (width == cachedDisplayMode.getWidth() && height == cachedDisplayMode.getHeight() && fullscreen == cachedFullscreen) {
            return;
        }
        if (fullscreen) {
            try {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                Arrays.sort(modes, 0, modes.length - 1, new BestDisplayModeComparator(width, height));
                DisplayMode newMode = modes[modes.length - 1];
                if (newMode.getWidth() != width || newMode.getHeight() != height) {
                    throw new RuntimeException("Failed to find a suitable " + width + "x" + height + " display mode.");
                }
                cachedDisplayMode = newMode;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            cachedDisplayMode = new DisplayMode(width, height);
        }
        try {
            Display.setDisplayMode((DisplayMode)cachedDisplayMode);
            Display.setFullscreen((boolean)fullscreen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void start(Class<? extends IGame> cls, State initialState) {
        Gamelib.start(cls, initialState, "Gamelib");
    }

    public static void start(Class<? extends IGame> cls, State initialState, String windowTitle) {
        try {
            Gamelib.start(cls.newInstance(), initialState, windowTitle);
        }
        catch (Exception e) {
            Gamelib.handle(e);
        }
    }

    public static void start(IGame game, State initialState) {
        Gamelib.start(game, initialState, "Gamelib");
    }

    public static void start(IGame game, State initialState, String windowTitle) {
        System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
        Gamelib.game = game;
        originalDisplayMode = Display.getDesktopDisplayMode();
        if (initialState == null) {
            throw new IllegalArgumentException("A game can't exist without a State.");
        }
        initialState.setup();
        if (windowTitle == null) {
            windowTitle = "";
        }
        Display.setTitle((String)windowTitle);
        Gamelib.tryCreatingDisplay();
        if (!GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            capabilities.setFBOSupport(false);
        }
        capabilities.lock();
        State.change(initialState);
        GL.initDisplay(cachedDisplayMode.getWidth(), cachedDisplayMode.getHeight());
        GL.enterOrtho(cachedDisplayMode.getWidth(), cachedDisplayMode.getHeight());
        GL.setup();
        State.get().create();
        isRunning = true;
        Gamelib.gameLoop();
        Display.destroy();
    }

    public static void stop() {
        isRunning = false;
    }

    private static void tryCreatingDisplay() {
        if (Gamelib.tryCreatingDisplay(new PixelFormat(8, 8, 8, 4))) {
            return;
        }
        capabilities.setMultisampleSupport(false);
        if (Gamelib.tryCreatingDisplay(new PixelFormat(8, 8, 8))) {
            return;
        }
        capabilities.setStencilSupport(false);
        if (Gamelib.tryCreatingDisplay(new PixelFormat(8, 8, 0))) {
            return;
        }
        capabilities.setAlphaSupport(false);
        if (Gamelib.tryCreatingDisplay(new PixelFormat())) {
            return;
        }
        throw new RuntimeException("Couldn't create display.");
    }

    private static boolean tryCreatingDisplay(PixelFormat format) {
        try {
            Display.create((PixelFormat)format);
            return true;
        }
        catch (Exception e) {
            Display.destroy();
            return false;
        }
    }

    protected static void gameLoop() {
        while (isRunning) {
            KInput.update();
            MInput.update();
            game.gameLoop();
            if (State.get() == null) continue;
            Gamelib.advanceFrame(State.get().getFPS());
        }
    }

    public static void advanceFrame() {
        Gamelib.advanceFrame(0);
    }

    public static void advanceFrame(int fps) {
        GL.unbind();
        Debug.advance();
        if (Display.isCloseRequested()) {
            isRunning = false;
        }
        Display.update();
        if (fps > 0) {
            Display.sync((int)fps);
        }
    }

    public static void handle(Throwable t) {
        t.printStackTrace();
    }

    public static double getDoubleTime() {
        return 1.0 * (double)Sys.getTime() / (double)Sys.getTimerResolution();
    }

    public static final class Capabilities {
        private boolean multisample = true;
        private boolean alpha = true;
        private boolean stencil = true;
        private boolean fbo = true;
        private boolean locked = false;

        public String toString() {
            return "[Gamelib.Capabilities: " + (this.multisample ? "" : "no ") + "multisampling, " + (this.alpha ? "" : "no ") + "alpha, " + (this.stencil ? "" : "no ") + "stencil, " + (this.fbo ? "" : "no ") + "FBO]";
        }

        public boolean multisampling() {
            return this.multisample;
        }

        public boolean alpha() {
            return this.alpha;
        }

        public boolean stencil() {
            return this.stencil;
        }

        public boolean FBO() {
            return this.fbo;
        }

        public void setMultisampleSupport(boolean b) {
            if (this.locked) {
                throw new IllegalStateException("This object is locked, it can't be modified.");
            }
            this.multisample = b;
        }

        public void setAlphaSupport(boolean b) {
            if (this.locked) {
                throw new IllegalStateException("This object is locked, it can't be modified.");
            }
            this.alpha = b;
        }

        public void setStencilSupport(boolean b) {
            if (this.locked) {
                throw new IllegalStateException("This object is locked, it can't be modified.");
            }
            this.stencil = b;
        }

        public void setFBOSupport(boolean b) {
            if (this.locked) {
                throw new IllegalStateException("This object is locked, it can't be modified.");
            }
            this.fbo = b;
        }

        public void lock() {
            this.locked = true;
        }
    }
}

