/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.json;

import pl.shockah.StrBuffer;
import pl.shockah.json.JSONList;
import pl.shockah.json.JSONObject;

public class JSONParser {
    protected static final String listWhitespace = " \r\n\t";

    public JSONObject parseObject(CharSequence cs) {
        StrBuffer strb = new StrBuffer();
        strb.append(cs);
        strb.setPos(0);
        return this.parseJSONObject(strb);
    }

    public JSONList<?> parseList(CharSequence cs) {
        StrBuffer strb = new StrBuffer();
        strb.append(cs);
        strb.setPos(0);
        return this.parseJSONList(strb);
    }

    protected JSONObject parseJSONObject(StrBuffer strb) {
        this.skipWhitespace(strb);
        if (strb.readChar() != '{') {
            throw new RuntimeException("Invalid JSON input.");
        }
        JSONObject j = new JSONObject();
        while (true) {
            this.skipWhitespace(strb);
            if (strb.atEnd()) break;
            char c = strb.readChar();
            if (c == '}') {
                strb.seek(-1);
                break;
            }
            if (c == ',') {
                this.skipWhitespace(strb);
            } else {
                strb.seek(-1);
            }
            this.parseJSONObjectEntry(strb, j);
        }
        this.skipWhitespace(strb);
        if (strb.readChar() != '}') {
            throw new RuntimeException("Invalid JSON input.");
        }
        return j;
    }

    protected void parseJSONObjectEntry(StrBuffer strb, JSONObject j) {
        if (strb.readChar() != '\"') {
            throw new RuntimeException("Invalid JSON input.");
        }
        strb.seek(-1);
        String key = this.parseString(strb);
        this.skipWhitespace(strb);
        if (strb.readChar() != ':') {
            throw new RuntimeException("Invalid JSON input.");
        }
        this.skipWhitespace(strb);
        j.put(key, this.parseValue(strb));
    }

    protected JSONList<?> parseJSONList(StrBuffer strb) {
        this.skipWhitespace(strb);
        if (strb.readChar() != '[') {
            throw new RuntimeException("Invalid JSON input.");
        }
        JSONList j = new JSONList();
        while (true) {
            this.skipWhitespace(strb);
            if (strb.atEnd()) break;
            char c = strb.readChar();
            if (c == ']') {
                strb.seek(-1);
                break;
            }
            if (c == ',') {
                this.skipWhitespace(strb);
            } else {
                strb.seek(-1);
            }
            this.parseJSONListEntry(strb, j);
        }
        this.skipWhitespace(strb);
        if (strb.readChar() != ']') {
            throw new RuntimeException("Invalid JSON input.");
        }
        return j;
    }

    protected void parseJSONListEntry(StrBuffer strb, JSONList<?> j) {
        this.skipWhitespace(strb);
        j.put(this.parseValue(strb));
    }

    protected void skipWhitespace(StrBuffer strb) {
        while (!strb.atEnd() && listWhitespace.indexOf(strb.readChar()) != -1) {
        }
        strb.seek(-1);
    }

    protected String parseString(StrBuffer strb) {
        return this.parseString(strb, true);
    }

    protected String parseWord(StrBuffer strb) {
        return this.parseString(strb, false);
    }

    protected String parseString(StrBuffer strb, boolean realString) {
        char chrStart = realString ? strb.readChar() : (char)'\u0000';
        StringBuilder sb = new StringBuilder();
        char store = '\u0000';
        while (true) {
            char c = strb.readChar();
            if (store != '\u0000') {
                if (c == '\\' || realString && c == chrStart) {
                    sb.append(c);
                } else {
                    switch (c) {
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                        }
                    }
                }
                store = '\u0000';
                continue;
            }
            if (c == '\\') {
                store = c;
                continue;
            }
            if (realString ? c == chrStart : c == ',' || c == ']' || c == '}' || listWhitespace.indexOf(c) != -1) {
                if (c == ',' || c == ']' || c == '}') {
                    strb.seek(-1);
                }
                return sb.toString();
            }
            sb.append(c);
        }
    }

    protected Object parseValue(StrBuffer strb) {
        Object val = null;
        char c = strb.readChar();
        strb.seek(-1);
        if (c == '\"') {
            val = this.parseString(strb);
        } else if (c == '{') {
            val = this.parseJSONObject(strb);
        } else if (c == '[') {
            val = this.parseJSONList(strb);
        } else {
            String word = this.parseWord(strb);
            if (word.equals("true")) {
                val = true;
            } else if (word.equals("false")) {
                val = false;
            } else {
                try {
                    val = Integer.parseInt(word);
                }
                catch (Exception e1) {
                    try {
                        val = Long.parseLong(word);
                    }
                    catch (Exception e2) {
                        try {
                            val = Float.valueOf(Float.parseFloat(word));
                        }
                        catch (Exception e3) {
                            try {
                                val = Double.parseDouble(word);
                            }
                            catch (Exception e4) {
                                val = null;
                            }
                        }
                    }
                }
            }
        }
        return val;
    }
}

