/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pl.shockah.json.JSONObject;

public class JSONList<T>
implements Iterable<T> {
    protected List<T> list = Collections.synchronizedList(new ArrayList());

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean holdsStrings() {
        if (this.isEmpty()) {
            return true;
        }
        for (T t : this.list) {
            if (t instanceof String) continue;
            return false;
        }
        return true;
    }

    public boolean holdsBooleans() {
        if (this.isEmpty()) {
            return true;
        }
        for (T t : this.list) {
            if (t instanceof Boolean) continue;
            return false;
        }
        return true;
    }

    public boolean holdsNumbers() {
        if (this.isEmpty()) {
            return true;
        }
        for (T t : this.list) {
            if (t instanceof Number) continue;
            return false;
        }
        return true;
    }

    public boolean holdsInts() {
        return this.holdsNumbers();
    }

    public boolean holdsLongs() {
        return this.holdsNumbers();
    }

    public boolean holdsFloat() {
        return this.holdsNumbers();
    }

    public boolean holdsDouble() {
        return this.holdsNumbers();
    }

    public boolean holdsObjects() {
        if (this.isEmpty()) {
            return true;
        }
        for (T t : this.list) {
            if (t instanceof JSONObject) continue;
            return false;
        }
        return true;
    }

    public boolean holdsLists() {
        if (this.isEmpty()) {
            return true;
        }
        for (T t : this.list) {
            if (t instanceof JSONList) continue;
            return false;
        }
        return true;
    }

    public boolean isNull(int index) {
        return this.list.get(index) == null;
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public String getString(int index) {
        T o = this.get(index);
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalArgumentException("Index '" + index + "' doesn't hold a string.");
    }

    public boolean getBoolean(int index) {
        T o = this.get(index);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException("Index '" + index + "' doesn't hold a boolean.");
    }

    public Number getNumber(int index) {
        T o = this.get(index);
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalArgumentException("Index '" + index + "' doesn't hold a number.");
    }

    public int getInt(int index) {
        return this.getNumber(index).intValue();
    }

    public long getLong(int index) {
        return this.getNumber(index).longValue();
    }

    public float getFloat(int index) {
        return this.getNumber(index).floatValue();
    }

    public double getDouble(int index) {
        return this.getNumber(index).doubleValue();
    }

    public JSONObject getObject(int index) {
        T o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new IllegalArgumentException("Index '" + index + "' doesn't hold a JSONObject.");
    }

    public JSONList<?> getList(int index) {
        T o = this.get(index);
        if (o instanceof JSONList) {
            return (JSONList)o;
        }
        throw new IllegalArgumentException("Index '" + index + "' doesn't hold a JSONList.");
    }

    public void put(Object o) {
        this.put(this.size(), o);
    }

    public void put(int index, Object o) {
        if (!(o == null || o instanceof String || o instanceof Number || o instanceof Boolean || o instanceof JSONObject || o instanceof JSONList)) {
            throw new IllegalArgumentException("Can't store this type of object.");
        }
        if (index >= this.size()) {
            this.list.add(o);
        } else {
            this.list.add(index, o);
        }
    }

    public T remove(int index) {
        return this.list.remove(index);
    }

    public JSONList<String> ofStrings() {
        return this;
    }

    public JSONList<Boolean> ofBooleans() {
        return this;
    }

    public JSONList<Integer> ofInts() {
        return this;
    }

    public JSONList<Long> ofLongs() {
        return this;
    }

    public JSONList<Float> ofFloats() {
        return this;
    }

    public JSONList<Double> ofDoubles() {
        return this;
    }

    public JSONList<JSONObject> ofObjects() {
        return this;
    }

    public JSONList<JSONList<?>> ofLists() {
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedList<T>(this.list).iterator();
    }
}

