/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.logic.standard.GameStandard;

public abstract class Renderable
implements Comparable<Renderable> {
    protected final EntityRenderable parent;
    private double depth = 0.0;

    public Renderable() {
        this(null);
    }

    public Renderable(double depth) {
        this(null, depth);
    }

    public Renderable(EntityRenderable er) {
        this(er, er.baseDepth);
    }

    public Renderable(EntityRenderable er, double depth) {
        this.parent = er;
        this.depth = depth;
    }

    @Override
    public final int compareTo(Renderable r) {
        if (this.depth == r.depth) {
            return 0;
        }
        return this.depth > r.depth ? -1 : 1;
    }

    public final EntityRenderable getParent() {
        return this.parent;
    }

    public final void create() {
        if (this.parent != null) {
            this.parent.renderables.add(this);
        }
        GameStandard.me.renderableAdd.add(this);
        this.onCreate();
    }

    protected void onCreate() {
    }

    public final void destroy() {
        this.onDestroy();
        GameStandard.me.renderableRemove.add(this);
        if (this.parent != null && !this.parent.isListUsed()) {
            this.parent.renderables.remove(this);
        }
    }

    protected void onDestroy() {
    }

    public final double getDepth() {
        return this.depth;
    }

    public final void setDepth(double depth) {
        this.depth = depth;
        if (GameStandard.me.renderable.contains(this)) {
            GameStandard.me.renderableRemove.add(this);
            GameStandard.me.renderableAdd.add(this);
        }
    }

    public final void render(Graphics g) {
        this.onRender(g);
    }

    protected void onRender(Graphics g) {
    }
}

