/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.logic.standard.GameStandard;

public abstract class EntityBase {
    public Vector2d pos = new Vector2d();
    private boolean firstTick = true;

    EntityBase() {
    }

    public final void create() {
        this.create(new Vector2d());
    }

    public final void create(double x, double y) {
        this.create(new Vector2d(x, y));
    }

    public void create(IVector2 pos) {
        this.pos.set(pos);
        this.firstTick = true;
        GameStandard.me.entitiesAdd.add(this);
        this.onCreate();
    }

    protected void onCreate() {
    }

    public void destroy() {
        this.onDestroy();
        GameStandard.me.entitiesRemove.add(this);
    }

    protected void onDestroy() {
    }

    public final void update() {
        this.firstUpdate();
        this.onUpdate();
    }

    public final void firstUpdate() {
        if (!this.firstTick) {
            return;
        }
        this.firstTick = false;
        this.onFirstUpdate();
    }

    protected void onFirstUpdate() {
    }

    protected void onUpdate() {
    }
}

