/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pl.shockah.glib.gl.tex.ImageIOTextureLoader;
import pl.shockah.glib.gl.tex.SVGTextureLoader;
import pl.shockah.glib.gl.tex.Texture;

public abstract class TextureLoader {
    private static final List<TextureLoader> loaders = new LinkedList<TextureLoader>();
    private final List<String> formats;
    protected final Map<String, Object> settings = new HashMap<String, Object>();

    static {
        loaders.add(new ImageIOTextureLoader("PNG", "GIF", "JPG", "JPEG", "BMP", "WBMP"));
        try {
            Class.forName("org.apache.batik.transcoder.image.PNGTranscoder");
            loaders.add(new SVGTextureLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static TextureLoader getTextureLoader(String format) {
        for (TextureLoader tl : loaders) {
            if (!tl.isSupported(format)) continue;
            return tl;
        }
        return null;
    }

    public static List<TextureLoader> getAll() {
        return Collections.unmodifiableList(loaders);
    }

    public static void setOptionGlobal(String option, Object value) {
        for (TextureLoader tl : loaders) {
            tl.setOption(option, value);
        }
    }

    public static void clearOptionsGlobal() {
        for (TextureLoader tl : loaders) {
            tl.clearOptions();
        }
    }

    public TextureLoader(String ... formats) {
        this.formats = new LinkedList<String>(Arrays.asList(formats));
    }

    public boolean isSupported(String format) {
        return this.formats.contains(format);
    }

    public void setOption(String option, Object value) {
        if (value == null) {
            if (this.settings.containsKey(option)) {
                this.settings.remove(option);
            }
        } else {
            this.settings.put(option, value);
        }
    }

    public void clearOptions() {
        this.settings.clear();
    }

    public abstract Texture load(InputStream var1) throws IOException;

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntOption {
        public String option();

        public int value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntOptions {
        public IntOption[] value();
    }
}

