/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import pl.shockah.glib.LoadableProcessor;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureSupplier;
import pl.shockah.json.JSONList;
import pl.shockah.json.JSONObject;

public class Atlas
extends TextureSupplier {
    protected final Image img;
    protected final Map<Object, Image> map = new HashMap<Object, Image>();

    public Atlas(Texture tex) {
        super(tex);
        this.img = new Image(tex);
    }

    public int getCount() {
        return this.map.size();
    }

    public Image getImage(Object key) {
        return this.map.get(key);
    }

    public void fillFromJSON(JSONObject j) {
        if (j.size() == 1 && j.contains("atlas") && j.get("atlas") instanceof JSONList) {
            JSONList<JSONObject> list = j.getList("atlas").ofObjects();
            int i = 0;
            while (i < list.size()) {
                JSONObject j2 = list.get(i);
                this.put(j2.get("key"), this.readRectangleFromJSON(j2.getObject("rect")));
                ++i;
            }
        } else {
            for (String key : j.keys()) {
                this.put(key, this.readRectangleFromJSON(j.getObject(key)));
            }
        }
    }

    protected Rectangle readRectangleFromJSON(JSONObject j) {
        int x = -1;
        int y = -1;
        int w = 0;
        int h = 0;
        if (j.contains("x")) {
            x = j.getInt("x");
        }
        if (j.contains("y")) {
            y = j.getInt("y");
        }
        if (j.contains("w")) {
            w = j.getInt("w");
        }
        if (j.contains("width")) {
            w = j.getInt("width");
        }
        if (j.contains("h")) {
            h = j.getInt("h");
        }
        if (j.contains("height")) {
            h = j.getInt("height");
        }
        if (j.contains("size")) {
            w = h = j.getInt("size");
        }
        if (x < 0 || y < 0 || w <= 0 || h <= 0) {
            throw new IllegalArgumentException();
        }
        return new Rectangle(x, y, w, h);
    }

    public void put(Object key, Rectangle rect) {
        this.map.put(key, this.img.part(rect));
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
        public String path() default "assets/spritesheets/<field.name>.png";

        public LoadableProcessor.AssetType type() default LoadableProcessor.AssetType.Internal;

        public boolean toPremultiplied() default false;
    }
}

