/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.color;

import org.lwjgl.opengl.GL11;
import pl.shockah.Math2;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.gl.color.Colorb;
import pl.shockah.glib.gl.color.ColorbMutable;
import pl.shockah.glib.gl.color.Colorf;
import pl.shockah.glib.gl.color.ColorfMutable;

public abstract class Color
implements IInterpolatable<Color> {
    public static final Color Black = new Colorb(0);
    public static final Color TransparentBlack = new Colorb(0, 0);
    public static final Color DimGray = new Colorb(105);
    public static final Color Gray = new Colorb(128);
    public static final Color DarkGray = new Colorb(169);
    public static final Color Silver = new Colorb(192);
    public static final Color LightGray = new Colorb(211);
    public static final Color Gainsboro = new Colorb(220);
    public static final Color WhiteSmoke = new Colorb(245);
    public static final Color TransparentWhite = new Colorb(255, 0);
    public static final Color White = new Colorb(255);
    public static final Color Maroon = new Colorb(128, 0, 0);
    public static final Color DarkRed = new Colorb(139, 0, 0);
    public static final Color Red = new Colorb(255, 0, 0);
    public static final Color Firebrick = new Colorb(178, 34, 34);
    public static final Color Brown = new Colorb(165, 42, 42);
    public static final Color SaddleBrown = new Colorb(139, 69, 19);
    public static final Color Sienna = new Colorb(160, 82, 45);
    public static final Color OrangeRed = new Colorb(255, 69, 0);
    public static final Color IndianRed = new Colorb(205, 92, 92);
    public static final Color Chocolate = new Colorb(210, 105, 30);
    public static final Color Tomato = new Colorb(255, 99, 71);
    public static final Color Peru = new Colorb(205, 133, 63);
    public static final Color RosyBrown = new Colorb(188, 143, 143);
    public static final Color Coral = new Colorb(255, 127, 80);
    public static final Color LightCoral = new Colorb(240, 128, 128);
    public static final Color Salmon = new Colorb(250, 128, 114);
    public static final Color DarkSalmon = new Colorb(233, 150, 122);
    public static final Color SandyBrown = new Colorb(244, 164, 96);
    public static final Color LightSalmon = new Colorb(255, 160, 122);
    public static final Color PeachPuff = new Colorb(255, 218, 185);
    public static final Color MistyRose = new Colorb(255, 228, 225);
    public static final Color SeaShell = new Colorb(255, 245, 238);
    public static final Color Snow = new Colorb(255, 250, 250);
    public static final Color DarkGoldenrod = new Colorb(184, 134, 11);
    public static final Color DarkOrange = new Colorb(255, 140, 0);
    public static final Color Goldenrod = new Colorb(218, 165, 32);
    public static final Color Orange = new Colorb(255, 165, 0);
    public static final Color DarkKhaki = new Colorb(189, 183, 107);
    public static final Color Tan = new Colorb(210, 180, 140);
    public static final Color BurlyWood = new Colorb(222, 184, 135);
    public static final Color Gold = new Colorb(255, 215, 0);
    public static final Color Khaki = new Colorb(240, 230, 140);
    public static final Color Wheat = new Colorb(245, 222, 179);
    public static final Color NavajoWhite = new Colorb(255, 222, 173);
    public static final Color PaleGoldenrod = new Colorb(238, 232, 170);
    public static final Color Moccasin = new Colorb(255, 228, 181);
    public static final Color Bisque = new Colorb(255, 228, 196);
    public static final Color AntiqueWhite = new Colorb(250, 235, 215);
    public static final Color BlanchedAlmond = new Colorb(255, 235, 205);
    public static final Color PapayaWhip = new Colorb(255, 239, 213);
    public static final Color Linen = new Colorb(250, 240, 230);
    public static final Color OldLace = new Colorb(253, 245, 230);
    public static final Color LemonChiffon = new Colorb(255, 250, 205);
    public static final Color Cornsilk = new Colorb(255, 248, 220);
    public static final Color FloralWhite = new Colorb(255, 250, 240);
    public static final Color DarkOliveGreen = new Colorb(85, 107, 47);
    public static final Color Olive = new Colorb(128, 128, 0);
    public static final Color OliveDrab = new Colorb(107, 142, 35);
    public static final Color YellowGreen = new Colorb(154, 205, 50);
    public static final Color GreenYellow = new Colorb(173, 255, 47);
    public static final Color Yellow = new Colorb(255, 255, 0);
    public static final Color Beige = new Colorb(245, 245, 220);
    public static final Color LightGoldenrodYellow = new Colorb(250, 250, 210);
    public static final Color LightYellow = new Colorb(255, 255, 224);
    public static final Color Ivory = new Colorb(255, 255, 240);
    public static final Color DarkSeaGreen = new Colorb(143, 188, 139);
    public static final Color LawnGreen = new Colorb(124, 252, 0);
    public static final Color Chartreuse = new Colorb(127, 255, 0);
    public static final Color DarkGreen = new Colorb(0, 100, 0);
    public static final Color Green = new Colorb(0, 128, 0);
    public static final Color ForestGreen = new Colorb(34, 139, 34);
    public static final Color SeaGreen = new Colorb(46, 139, 87);
    public static final Color MediumSeaGreen = new Colorb(60, 179, 113);
    public static final Color LimeGreen = new Colorb(50, 205, 50);
    public static final Color Lime = new Colorb(0, 255, 0);
    public static final Color SpringGreen = new Colorb(0, 255, 127);
    public static final Color LightGreen = new Colorb(144, 238, 144);
    public static final Color PaleGreen = new Colorb(152, 251, 152);
    public static final Color Honeydew = new Colorb(240, 255, 240);
    public static final Color LightSeaGreen = new Colorb(32, 178, 170);
    public static final Color MediumSpringGreen = new Colorb(0, 250, 154);
    public static final Color MediumTurquoise = new Colorb(72, 209, 204);
    public static final Color MediumAquamarine = new Colorb(102, 205, 170);
    public static final Color Turquiose = new Colorb(64, 224, 208);
    public static final Color Aquamarine = new Colorb(127, 255, 212);
    public static final Color MintCream = new Colorb(245, 255, 250);
    public static final Color DarkSlateGray = new Colorb(47, 79, 79);
    public static final Color Teal = new Colorb(0, 128, 128);
    public static final Color DarkCyan = new Colorb(0, 139, 139);
    public static final Color SteelBlue = new Colorb(70, 130, 180);
    public static final Color DodgerBlue = new Colorb(30, 144, 255);
    public static final Color CadetBlue = new Colorb(95, 158, 160);
    public static final Color DeepSkyBlue = new Colorb(0, 191, 255);
    public static final Color DarkTurquoise = new Colorb(0, 206, 209);
    public static final Color Aqua = new Colorb(0, 255, 255);
    public static final Color Cyan = new Colorb(0, 255, 255);
    public static final Color SkyBlue = new Colorb(135, 206, 235);
    public static final Color LightSkyBlue = new Colorb(135, 206, 250);
    public static final Color LightBlue = new Colorb(173, 216, 230);
    public static final Color PowderBlue = new Colorb(176, 224, 230);
    public static final Color PaleTurquoise = new Colorb(175, 238, 238);
    public static final Color LightCyan = new Colorb(224, 255, 255);
    public static final Color AliceBlue = new Colorb(240, 248, 255);
    public static final Color Azure = new Colorb(240, 255, 255);
    public static final Color RoyalBlue = new Colorb(65, 105, 225);
    public static final Color SlateGray = new Colorb(112, 128, 144);
    public static final Color LightSlateGray = new Colorb(119, 136, 153);
    public static final Color CornflowerBlue = new Colorb(100, 149, 237);
    public static final Color LightSteelBlue = new Colorb(176, 196, 222);
    public static final Color Navy = new Colorb(0, 0, 128);
    public static final Color DarkBlue = new Colorb(0, 0, 139);
    public static final Color MediumBlue = new Colorb(0, 0, 205);
    public static final Color Blue = new Colorb(0, 0, 255);
    public static final Color MidnightBlue = new Colorb(25, 25, 112);
    public static final Color DarkSlateBlue = new Colorb(72, 61, 139);
    public static final Color SlateBlue = new Colorb(106, 90, 205);
    public static final Color MediumSlateBlue = new Colorb(123, 104, 238);
    public static final Color MediumPurple = new Colorb(147, 112, 219);
    public static final Color Lavender = new Colorb(230, 230, 250);
    public static final Color GhostWhite = new Colorb(248, 248, 255);
    public static final Color Indigo = new Colorb(75, 0, 130);
    public static final Color DarkViolet = new Colorb(148, 0, 211);
    public static final Color BlueViolet = new Colorb(138, 43, 226);
    public static final Color DarkOrchid = new Colorb(153, 50, 204);
    public static final Color MediumOrchid = new Colorb(186, 85, 211);
    public static final Color Purple = new Colorb(128, 0, 128);
    public static final Color DarkMagenta = new Colorb(139, 0, 139);
    public static final Color MediumVioletRed = new Colorb(199, 21, 133);
    public static final Color DeepPink = new Colorb(255, 20, 147);
    public static final Color Fuchsia = new Colorb(255, 0, 255);
    public static final Color Magenta = new Colorb(255, 0, 255);
    public static final Color Orchid = new Colorb(218, 112, 214);
    public static final Color Violet = new Colorb(238, 130, 238);
    public static final Color Plum = new Colorb(221, 160, 221);
    public static final Color Thistle = new Colorb(216, 191, 216);
    public static final Color Crimson = new Colorb(220, 20, 60);
    public static final Color PaleVioletRed = new Colorb(219, 112, 147);
    public static final Color HotPink = new Colorb(255, 105, 180);
    public static final Color LightPink = new Colorb(225, 182, 193);
    public static final Color Pink = new Colorb(255, 192, 203);
    public static final Color LavenderBlush = new Colorb(255, 240, 245);

    public static Color fromHSB(float H, float S, float B) {
        java.awt.Color awtc = java.awt.Color.getHSBColor(H, S, B);
        return new Colorb(awtc.getRed(), awtc.getGreen(), awtc.getBlue());
    }

    public static Color fromPackedValue(int value) {
        return new Colorb((value & 0xFF0000) >> 16, (value & 0xFF00) >> 8, value & 0xFF, (value & 0xFF000000) >> 24);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Color)) {
            return false;
        }
        Color c = (Color)other;
        return this.R() == c.R() && this.G() == c.G() && this.B() == c.B() && this.A() == c.A();
    }

    public String toString() {
        return String.format("[Color: %d,%d,%d,%d]", this.R(), this.G(), this.B(), this.A());
    }

    public abstract int R();

    public abstract int G();

    public abstract int B();

    public abstract int A();

    public abstract float Rf();

    public abstract float Gf();

    public abstract float Bf();

    public abstract float Af();

    @Override
    public Color copyMe() {
        return new ColorbMutable(this.R(), this.G(), this.B(), this.A());
    }

    public void copy(Color c) {
        throw new UnsupportedOperationException();
    }

    public void bind() {
        GL11.glColor4f((float)this.Rf(), (float)this.Gf(), (float)this.Bf(), (float)this.Af());
    }

    public Color alpha(float alpha) {
        return new Colorb(this.Rf(), this.Gf(), this.Bf(), Math2.limit(this.Af() * alpha, 0.0f, 1.0f));
    }

    public Color setAlpha(float alpha) {
        return new Colorb(this.Rf(), this.Gf(), this.Bf(), Math2.limit(alpha, 0.0f, 1.0f));
    }

    public Color premultiply() {
        return new Colorf(this.Rf() * this.Af(), this.Gf() * this.Af(), this.Bf() * this.Af(), this.Af());
    }

    public Color inverse() {
        return new Colorb(255 - this.R(), 255 - this.G(), 255 - this.B(), this.A());
    }

    public ColorbMutable toColorbMutable() {
        if (this.getClass() == ColorbMutable.class) {
            return (ColorbMutable)this;
        }
        return new ColorbMutable(this.R(), this.G(), this.B(), this.A());
    }

    public Colorb toColorb() {
        if (this.getClass() == Colorb.class) {
            return (Colorb)this;
        }
        return new Colorb(this.R(), this.G(), this.B(), this.A());
    }

    public ColorfMutable toColorfMutable() {
        if (this.getClass() == ColorfMutable.class) {
            return (ColorfMutable)this;
        }
        return new ColorfMutable(this.Rf(), this.Gf(), this.Bf(), this.Af());
    }

    public Colorf toColorf() {
        if (this.getClass() == Colorf.class) {
            return (Colorf)this;
        }
        return new Colorf(this.Rf(), this.Gf(), this.Bf(), this.Af());
    }

    @Override
    public Color interpolate(Color c, double d, Interpolate method) {
        return new ColorbMutable(method.interpolate(this.Rf(), c.Rf(), d), method.interpolate(this.Gf(), c.Gf(), d), method.interpolate(this.Bf(), c.Bf(), d), method.interpolate(this.Af(), c.Af(), d));
    }
}

