/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom;

import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.polygon.IPolygonable;
import pl.shockah.glib.geom.polygon.Polygon;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;

public class Circle
extends Shape
implements IPolygonable,
IInterpolatable<Circle> {
    public Vector2d pos;
    public double radius;
    protected Vector2d lastPos;
    protected int lastPrecision = -1;
    protected Polygon lastPoly = null;

    public Circle(double x, double y, double radius) {
        this.pos = new Vector2d(x, y);
        this.radius = radius;
    }

    public Circle(Vector2d pos, double radius) {
        this.pos = pos;
        this.radius = radius;
    }

    public Circle(Circle circle) {
        this.pos = new Vector2d(circle.pos);
        this.radius = circle.radius;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Circle)) {
            return false;
        }
        Circle c = (Circle)other;
        return this.pos.equals(c.pos) && this.radius == c.radius;
    }

    public String toString() {
        return String.format("[Circle: pos %s, radius %s]", this.pos, this.radius);
    }

    @Override
    public Shape copy() {
        return this.copyMe();
    }

    @Override
    public Circle copyMe() {
        return new Circle(this);
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.pos.x - this.radius, this.pos.y - this.radius, this.radius * 2.0, this.radius * 2.0);
    }

    @Override
    public Vector2d translate(double x, double y) {
        this.pos.x += x;
        this.pos.y += y;
        return new Vector2d(x, y);
    }

    @Override
    public Vector2d translateTo(double x, double y) {
        Vector2d v = new Vector2d(x - this.pos.x, y - this.pos.y);
        this.pos.x = x;
        this.pos.y = y;
        return v;
    }

    @Override
    protected boolean collides(Shape shape, boolean secondTry) {
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            return this.pos.distanceSquared(circle.pos) < Math.pow(this.radius + circle.radius, 2.0);
        }
        if (shape instanceof Rectangle) {
            if (secondTry) {
                return super.collides(shape);
            }
            return shape.collides(this, true);
        }
        return super.collides(shape);
    }

    @Override
    public Polygon asPolygon() {
        return this.asPolygon((int)Math.ceil(Math.PI * this.radius / 2.0));
    }

    public Polygon asPolygon(int precision) {
        if (this.lastPoly != null && this.lastPoly.getPointCount() == precision && this.lastPrecision == precision && this.lastPos.equals(this.pos)) {
            return this.lastPoly;
        }
        Polygon.NoHoles p = new Polygon.NoHoles();
        int i = 0;
        while (i < precision) {
            p.addPoint(Vector2d.make(this.radius, 360.0 / (double)precision * (double)i).add(this.pos));
            ++i;
        }
        this.lastPos = this.pos;
        this.lastPrecision = precision;
        this.lastPoly = p;
        return this.lastPoly;
    }

    @Override
    public void draw(Graphics g, boolean filled) {
        this.asPolygon().draw(g, filled);
    }

    public void draw(Graphics g, boolean filled, int precision) {
        this.asPolygon(precision).draw(g, filled);
    }

    @Override
    public Circle interpolate(Circle c, double d, Interpolate method) {
        return new Circle(this.pos.interpolate(c.pos, d, method), method.interpolate(this.radius, c.radius, d));
    }
}

