/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import pl.shockah.Pair;

public class WeightedRandom<T> {
    protected LinkedList<Pair<T, Double>> list = new LinkedList();
    protected final Random rand;

    public WeightedRandom() {
        this(new Random());
    }

    public WeightedRandom(long seed) {
        this();
        this.rand.setSeed(seed);
    }

    public WeightedRandom(Random rand) {
        this.rand = rand;
    }

    public void add(T element, double weight) {
        this.list.add(new Pair<T, Double>(element, weight));
    }

    public void remove(T element) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (!((Pair)iterator.next()).get1().equals(element)) continue;
            iterator.remove();
        }
    }

    public T get() {
        double r = this.rand.nextDouble();
        double t = 0.0;
        for (Pair pair : this.list) {
            t += ((Double)pair.get2()).doubleValue();
        }
        r *= t;
        for (Pair pair : this.list) {
            if (r > (Double)pair.get2()) {
                r -= ((Double)pair.get2()).doubleValue();
                continue;
            }
            return (T)pair.get1();
        }
        return null;
    }
}

