/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public class SortedLinkedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = -4751208078850005267L;
    protected final Comparator<E> comparator;

    public SortedLinkedList() {
        this.comparator = null;
    }

    public SortedLinkedList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    protected int compareObjects(E e1, E e2) {
        if (this.comparator != null) {
            return this.comparator.compare(e1, e2);
        }
        return ((Comparable)e1).compareTo(e2);
    }

    @Override
    public boolean add(E e) {
        ListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (this.compareObjects(e, next) >= 0) continue;
            it.previous();
            it.add(e);
            it.next();
            return true;
        }
        super.add(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.add(e);
        return true;
    }

    @Override
    public void push(E e) {
        this.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public Object clone() {
        SortedLinkedList ret = new SortedLinkedList();
        for (Object e : this) {
            ret.add(e);
        }
        return ret;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }
}

