/*
 * Decompiled with CFR 0.152.
 */
package ds343gf;

import ds343gf.H3423t;
import ds343gf.L4535;

public abstract class J3434 {
    protected String name = null;
    protected TweenerMode mode = TweenerMode.PERSIST;
    protected L4535 parent = null;
    protected boolean active = true;
    protected boolean finished = false;
    protected float t = 0.0f;
    private float time = 0.0f;
    protected float target = 0.0f;
    protected boolean deltaTiming = false;
    protected int easingFunction = -1;

    public J3434(float duration, TweenerMode type, int easingType, boolean active) {
        this(duration, type, easingType, false, active);
    }

    public J3434(float duration, TweenerMode type, int easingType, boolean deltaTiming, boolean active) {
        this.target = duration;
        this.active = active;
        this.deltaTiming = deltaTiming;
        this.easingFunction = easingType;
    }

    public void update(int delta) {
        this.time = this.deltaTiming ? (this.time += (float)delta) : (this.time += 1.0f);
        this.t = this.time / this.target;
        if (this.easingFunction != -1 && this.t > 0.0f && this.t < 1.0f) {
            this.t = H3423t.ease(this.easingFunction, this.t);
        }
        if (this.time > this.target) {
            this.t = 1.0f;
            this.finished = true;
        }
    }

    public void start() {
        this.active = true;
        this.time = 0.0f;
        if (this.target == 0.0f) {
            this.active = false;
        }
    }

    public void pause() {
        this.active = false;
    }

    public void reset() {
        this.time = 0.0f;
        this.active = false;
    }

    public void finish() {
        switch (this.mode) {
            case PERSIST: {
                this.time = this.target;
                this.active = false;
                break;
            }
            case ONESHOT: {
                this.time = this.target;
                this.active = false;
                if (this.parent == null) break;
                this.parent.remove(this);
                break;
            }
            case LOOPING: {
                this.time %= this.target;
                this.t = this.time / this.target;
            }
        }
        this.finished = false;
    }

    public float getValue() {
        return this.t;
    }

    public float getPercentage() {
        return this.time / this.target;
    }

    public void setPercentage(float val) {
        this.time = this.target * val;
    }

    public boolean isActive() {
        return this.active;
    }

    public TweenerMode getMode() {
        return this.mode;
    }

    public void setMode(TweenerMode mode) {
        this.mode = mode;
    }

    public L4535 getParent() {
        return this.parent;
    }

    public void setParent(L4535 parent) {
        this.parent = parent;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static enum TweenerMode {
        ONESHOT,
        LOOPING,
        PERSIST;

    }
}

