/*
 * Decompiled with CFR 0.152.
 */
package tr545ma345;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.BigImage;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tr545ma345.KTR55y;

public class J54tg {
    private static String baseDir = null;
    private static float sfxVolume = 1.0f;
    private static float musicVolume = 1.0f;
    private static HashMap<String, Sound> sounds = new HashMap();
    private static HashMap<String, Music> songs = new HashMap();
    private static HashMap<String, Image> images = new HashMap();
    private static HashMap<String, SpriteSheet> sheets = new HashMap();
    private static HashMap<String, List<KTR55y>> spriteInfo = new HashMap();
    private static HashMap<String, AngelCodeFont> fonts = new HashMap();
    private static HashMap<String, Integer> ints = new HashMap();
    private static HashMap<String, Float> floats = new HashMap();
    private static HashMap<String, String> strings = new HashMap();
    private static HashMap<String, TiledMap> maps = new HashMap();

    public static void loadResources(String ref) throws IOException {
        J54tg.loadResources(ResourceLoader.getResourceAsStream(ref));
    }

    public static void loadResources(File ref) throws IOException {
        J54tg.loadResources(new FileInputStream(ref));
    }

    public static void loadResources(InputStream ref) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(ref);
            Element element = document.getDocumentElement();
            if (!element.getNodeName().equals("resources")) {
                throw new IOException("Not a resource configuration file");
            }
            NodeList list = element.getElementsByTagName("basedir");
            int i = 0;
            while (i < list.getLength()) {
                J54tg.setBaseDirectory((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("sound");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadSound((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("music");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadMusic((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("image");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadImage((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("sheet");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadSpriteSheet((Element)list.item(i));
                J54tg.loadSprite((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("angelcodefont");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadAngelCodeFont((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("map");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadTiledMap((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("int");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadInt((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("float");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadFloat((Element)list.item(i));
                ++i;
            }
            list = element.getElementsByTagName("string");
            i = 0;
            while (i < list.getLength()) {
                J54tg.loadString((Element)list.item(i));
                ++i;
            }
        }
        catch (IOException e) {
            Log.error(e);
            throw e;
        }
        catch (Exception e) {
            Log.error(e);
            throw new IOException("Unable to load resource configuration file");
        }
    }

    private static void loadSprite(Element sprsheet) {
        String key = sprsheet.getAttribute("key");
        NodeList sprites = sprsheet.getElementsByTagName("sprite");
        if (sprites != null) {
            int i = 0;
            while (i < sprites.getLength()) {
                J54tg.loadSpriteInformation((Element)sprites.item(i), key);
                ++i;
            }
        }
    }

    private static void loadSpriteInformation(Element sprite, String spriteSheetKey) {
        String id = sprite.getAttribute("id");
        String type = sprite.getAttribute("type");
        List<KTR55y> infos = spriteInfo.get(spriteSheetKey);
        if (infos == null) {
            infos = new ArrayList<KTR55y>();
        }
        infos.add(new KTR55y(id, type));
        Collections.sort(infos);
        spriteInfo.put(spriteSheetKey, infos);
    }

    public static void loadTiledMap(Element map) throws SlickException {
        String key = map.getAttribute("key");
        String file = map.getAttribute("file");
        Log.debug("Trying to load tiled map file '" + file + "' at key '" + key + "'...");
        TiledMap tiledMap = new TiledMap(String.valueOf(baseDir) + file);
        maps.put(key, tiledMap);
    }

    private static void setBaseDirectory(Element basedir) throws SlickException {
        String dir = basedir.getAttribute("path");
        J54tg.setBaseDirectory(dir);
    }

    public static void setBaseDirectory(String baseDirectory) throws SlickException {
        Log.debug("Setting ResourceManager base directory to '" + baseDirectory + "'");
        if (baseDirectory == null || baseDirectory.isEmpty()) {
            throw new SlickException("BaseDirectory must not be null or empty!");
        }
        baseDir = baseDirectory;
        if (!baseDir.endsWith("/")) {
            baseDir = String.valueOf(baseDir) + "/";
        }
    }

    private static void loadMusic(Element music) throws SlickException {
        String key = music.getAttribute("key");
        String file = music.getAttribute("file");
        J54tg.loadMusic(key, file);
    }

    public static void loadMusic(String key, String file) throws SlickException {
        Log.debug("Trying to load music file '" + file + "' at key '" + key + "'...");
        if (songs.get(key) != null) {
            throw new SlickException("Music for key " + key + " already existing!");
        }
        if (baseDir != null && !file.startsWith(baseDir)) {
            file = String.valueOf(baseDir) + file;
        }
        Music song = new Music(file);
        songs.put(key, song);
    }

    public static Music getMusic(String key) {
        Music music = songs.get(key);
        if (music == null) {
            Log.error("No music for key " + key + " found!");
        }
        return music;
    }

    private static void loadSound(Element snd) throws SlickException {
        String key = snd.getAttribute("key");
        String file = snd.getAttribute("file");
        J54tg.loadSound(key, file);
    }

    public static void loadSound(String key, String file) throws SlickException {
        Log.debug("Trying to load sound file '" + file + "' at key '" + key + "'...");
        if (sounds.get(key) != null) {
            throw new SlickException("Sound for key " + key + " already existing!");
        }
        if (baseDir != null && !file.startsWith(baseDir)) {
            file = String.valueOf(baseDir) + file;
        }
        Sound sound = new Sound(file);
        sounds.put(key, sound);
    }

    public static Sound getSound(String key) {
        Sound sound = sounds.get(key);
        if (sound == null) {
            Log.error("No sound for key " + key + " found!");
        }
        return sound;
    }

    private static void loadImage(Element img) throws SlickException {
        String key = img.getAttribute("key");
        String file = img.getAttribute("file");
        String transColor = img.getAttribute("transparentColor");
        Color transparentColor = null;
        if (transColor != null && !transColor.isEmpty()) {
            transparentColor = Color.decode(transColor);
        } else {
            transColor = null;
        }
        J54tg.loadImage(key, file, transparentColor);
    }

    public static void loadImage(String key, String file, Color transparentColor) throws SlickException {
        Log.debug("Trying to load image file '" + file + "' at key '" + key + "'...");
        if (images.get(key) != null) {
            throw new SlickException("Image for key " + key + " already existing!");
        }
        if (baseDir != null && !file.startsWith(baseDir)) {
            file = String.valueOf(baseDir) + file;
        }
        try {
            Image image = transparentColor != null ? new Image(file, transparentColor) : new Image(file);
            images.put(key, image);
        }
        catch (Exception e) {
            Log.info("Texture too big for this hardware, try to use BigImage.. ignoring transparent color!");
            BigImage image = new BigImage(file);
            images.put(key, image);
        }
    }

    public static Image getImage(String key) {
        Image image = images.get(key);
        return image;
    }

    private static void loadSpriteSheet(Element sprsheet) throws SlickException {
        String key = sprsheet.getAttribute("key");
        String file = sprsheet.getAttribute("file");
        int width = Integer.parseInt(sprsheet.getAttribute("width"));
        int height = Integer.parseInt(sprsheet.getAttribute("height"));
        String transColor = sprsheet.getAttribute("transparentColor");
        Color transparentColor = null;
        if (transColor != null && !transColor.isEmpty()) {
            transparentColor = Color.decode(transColor);
        } else {
            transColor = null;
        }
        J54tg.loadSpriteSheet(key, file, width, height, transparentColor);
    }

    public static void loadSpriteSheet(String key, String file, int width, int height, Color transparentColor) throws SlickException {
        Log.debug("Trying to load spritesheet file '" + file + "' with width " + width + " and height " + height + (transparentColor == null ? " without transparent color" : " with transparent color '" + transparentColor.toString() + "'") + " at key '" + key + "'...");
        if (sheets.get(key) != null) {
            throw new SlickException("SpriteSheet for key " + key + " already existing!");
        }
        SpriteSheet spriteSheet = null;
        if (baseDir != null && !file.startsWith(baseDir)) {
            file = String.valueOf(baseDir) + file;
        }
        spriteSheet = transparentColor == null ? new SpriteSheet(file, width, height) : new SpriteSheet(file, width, height, transparentColor);
        sheets.put(key, spriteSheet);
    }

    public static SpriteSheet getSpriteSheet(String key) {
        SpriteSheet spriteSheet = sheets.get(key);
        if (spriteSheet == null) {
            Log.error("No SpriteSheet for key " + key + " found!");
        }
        return spriteSheet;
    }

    public static HashMap<String, SpriteSheet> getSpriteSheets() {
        return sheets;
    }

    private static void loadAngelCodeFont(Element fnt) throws SlickException {
        String key = fnt.getAttribute("key");
        String fntfile = fnt.getAttribute("fontFile");
        String imagefile = fnt.getAttribute("imageFile");
        J54tg.loadAngelCodeFont(key, fntfile, imagefile);
    }

    public static void loadAngelCodeFont(String key, String fontFile, String imageFile) throws SlickException {
        Log.debug("Trying to load Angelcode font file '" + fontFile + "' and imagefile '" + imageFile + "' at key '" + key + "'...");
        if (fonts.get(key) != null) {
            throw new SlickException("AngelCodeFont for key " + key + " already existing!");
        }
        if (baseDir != null && !fontFile.startsWith(baseDir)) {
            fontFile = String.valueOf(baseDir) + fontFile;
            imageFile = String.valueOf(baseDir) + imageFile;
        }
        AngelCodeFont font = new AngelCodeFont(fontFile, imageFile, true);
        fonts.put(key, font);
    }

    public static AngelCodeFont getAngelCodeFont(String key) {
        AngelCodeFont font = fonts.get(key);
        if (font == null) {
            Log.error("No AngelCodeFont for key " + key + " found!");
        }
        return font;
    }

    private static void loadInt(Element intval) throws SlickException {
        String key = intval.getAttribute("key");
        String value = intval.getAttribute("value");
        int val = Integer.parseInt(value);
        J54tg.setInt(key, val);
    }

    public static void setInt(String key, int value) {
        ints.put(key, value);
    }

    public static int getInt(String key) {
        Integer intval = ints.get(key);
        if (intval == null) {
            Log.error("No int for key " + key + " found!");
        }
        return intval;
    }

    private static void loadFloat(Element floatval) throws SlickException {
        String key = floatval.getAttribute("key");
        String value = floatval.getAttribute("value");
        float val = Float.parseFloat(value);
        J54tg.setFloat(key, val);
    }

    public static void setFloat(String key, float value) {
        floats.put(key, Float.valueOf(value));
    }

    public static float getFloat(String key) {
        Float floatval = floats.get(key);
        if (floatval == null) {
            Log.error("No float for key " + key + " found!");
        }
        return floatval.floatValue();
    }

    private static void loadString(Element stringval) throws SlickException {
        String key = stringval.getAttribute("key");
        String value = stringval.getAttribute("value");
        J54tg.setString(key, value);
    }

    public static void setString(String key, String value) {
        strings.put(key, value);
    }

    public static String getString(String key) {
        String val = strings.get(key);
        if (val == null) {
            Log.error("No string for key" + key + " found!");
        }
        return val;
    }

    public static TiledMap getMap(String key) {
        TiledMap map = maps.get(key);
        if (map == null) {
            Log.error("No map for key " + key + " found!");
        }
        return map;
    }

    public static void setSfxVolume(float volume) {
        sfxVolume = volume;
        SoundStore.get().setSoundVolume(sfxVolume);
    }

    public static void setMusicVolume(float volume) {
        musicVolume = volume;
        SoundStore.get().setMusicVolume(musicVolume);
    }

    public static float getMusicVolume() {
        return musicVolume;
    }

    public static float getSfxVolume() {
        return sfxVolume;
    }

    public static List<KTR55y> getSpriteInfo(String spriteSheet) {
        List<KTR55y> infos = spriteInfo.get(spriteSheet);
        if (infos == null) {
            Log.error("No sprite info found for spritesheet with key " + spriteSheet);
        }
        return infos;
    }

    public static KTR55y getSpriteInfo(String spriteSheet, String id) {
        List<KTR55y> infos = J54tg.getSpriteInfo(spriteSheet);
        if (infos != null) {
            for (KTR55y spriteInfo : infos) {
                if (!spriteInfo.getId().equalsIgnoreCase(id)) continue;
                return spriteInfo;
            }
        }
        return null;
    }

    public static ArrayList<Image> getImagesAsListWithoutKeys(List<String> keys) {
        ArrayList<Image> list = new ArrayList<Image>();
        for (String key : images.keySet()) {
            if (key == null) continue;
            boolean found = false;
            for (String without : keys) {
                if (!key.contains(without)) continue;
                found = true;
            }
            if (found) continue;
            list.add(images.get(key));
        }
        return list;
    }
}

