/*
 * Decompiled with CFR 0.152.
 */
package tr545ma345;

import grt45eb4.ETerget;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Vector2f;
import tr545ma345.YERhb;

public class H4636 {
    private YERhb myWorld;
    public float cameraX = 0.0f;
    public float cameraY = 0.0f;
    private float renderWidth;
    private float renderHeight;
    private Vector2f maxSpeed = null;
    private int horBorderPixel = 0;
    private int vertBorderPixel = 0;
    private Rectangle visibleRect = null;
    private Rectangle moveRect = null;
    private ETerget follow;

    public H4636(YERhb world, ETerget toFollow, int width, int height) {
        this(world, toFollow, width, height, -1, -1, null);
    }

    public H4636(YERhb world, ETerget toFollow, int width, int height, int horBorderPixel, int vertBorderPixel, Vector2f maxSpeed) {
        this.renderWidth = width;
        this.renderHeight = height;
        this.follow = toFollow;
        this.horBorderPixel = horBorderPixel;
        this.vertBorderPixel = vertBorderPixel;
        this.maxSpeed = maxSpeed;
        if (toFollow != null) {
            this.cameraX = this.follow.x - this.renderWidth / 2.0f;
            this.cameraY = this.follow.y - this.renderHeight / 2.0f;
        }
        this.myWorld = world;
        this.visibleRect = new Rectangle(this.cameraX - (float)horBorderPixel, this.cameraY - (float)vertBorderPixel, this.renderWidth + (float)horBorderPixel, this.renderHeight + (float)vertBorderPixel);
        this.moveRect = new Rectangle(this.cameraX - (float)horBorderPixel, this.cameraY - (float)vertBorderPixel, this.renderWidth + (float)horBorderPixel, this.renderHeight + (float)vertBorderPixel);
        this.setCamera();
    }

    public void update(GameContainer container, int delta) throws SlickException {
        this.setCamera();
    }

    private void setCamera() {
        if (this.follow != null && !this.moveRect.contains(this.follow.x + (float)(this.follow.width / 2), this.follow.y + (float)(this.follow.height / 2))) {
            float targetCX = this.follow.x - this.renderWidth / 2.0f;
            float targetCY = this.follow.y - this.renderHeight / 2.0f;
            if (this.maxSpeed != null) {
                this.cameraX = Math.abs(targetCX - this.cameraX) > this.maxSpeed.x ? (targetCX > this.cameraX ? (this.cameraX += this.maxSpeed.x * 2.0f) : (this.cameraX -= this.maxSpeed.x * 2.0f)) : targetCX;
                this.cameraY = Math.abs(targetCY - this.cameraY) > this.maxSpeed.y ? (targetCY > this.cameraY ? (this.cameraY += this.maxSpeed.y * 2.0f) : (this.cameraY -= this.maxSpeed.y * 2.0f)) : targetCY;
            } else {
                this.cameraX = targetCX;
                this.cameraY = targetCY;
            }
        }
        if (this.cameraX < 0.0f) {
            this.cameraX = 0.0f;
        }
        if (this.cameraX + this.renderWidth > (float)this.myWorld.width) {
            this.cameraX = (float)this.myWorld.width - this.renderWidth + 1.0f;
        }
        if (this.cameraY < 0.0f) {
            this.cameraY = 0.0f;
        }
        if (this.cameraY + this.renderHeight > (float)this.myWorld.height) {
            this.cameraY = (float)this.myWorld.height - this.renderHeight + 1.0f;
        }
        if (this.follow != null) {
            this.visibleRect.setBounds(this.cameraX - (float)this.horBorderPixel, this.cameraY - (float)this.vertBorderPixel, this.renderWidth + (float)this.horBorderPixel, this.renderHeight + (float)this.vertBorderPixel);
            this.moveRect.setBounds(this.cameraX + (float)(this.horBorderPixel / 2) - this.follow.speed.x, this.cameraY + (float)(this.vertBorderPixel / 2), this.renderWidth - (float)this.horBorderPixel + this.follow.speed.x, this.renderHeight - (float)this.vertBorderPixel);
        }
    }

    public boolean contains(ETerget e) {
        Rectangle entity = new Rectangle(e.x, e.y, e.width, e.height);
        return this.visibleRect.intersects(entity);
    }

    public YERhb getMyWorld() {
        return this.myWorld;
    }

    public void setMyWorld(YERhb myWorld) {
        this.myWorld = myWorld;
    }

    public ETerget getFollow() {
        return this.follow;
    }

    public void setFollow(ETerget follow) {
        this.follow = follow;
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public Rectangle getMoveRect() {
        return this.moveRect;
    }
}

