/*
 * Decompiled with CFR 0.152.
 */
package ds343gf;

import ds343gf.J3434;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class L4535 {
    private List<J3434> tweens = new ArrayList<J3434>();

    public L4535(J3434 ... tweens) {
        if (tweens != null) {
            List<J3434> allTweens = Arrays.asList(tweens);
            this.tweens.addAll(allTweens);
            for (J3434 tween : allTweens) {
                tween.setParent(this);
            }
        }
    }

    public boolean add(J3434 tween) {
        return this.add(tween, true);
    }

    public boolean add(J3434 tween, boolean start) {
        if (tween != null && tween.getParent() == null) {
            boolean result = this.tweens.add(tween);
            tween.setActive(true);
            return result;
        }
        return false;
    }

    public boolean remove(J3434 tween) {
        if (tween == null || tween.getParent() != this) {
            return false;
        }
        boolean result = this.tweens.remove(tween);
        tween.setActive(false);
        tween.setParent(null);
        return result;
    }

    public void clearTweens() {
        for (J3434 tween : this.tweens) {
            tween.setActive(false);
            tween.setParent(null);
        }
        this.tweens = new ArrayList<J3434>();
    }

    public J3434 getTween(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (J3434 tween : this.tweens) {
            if (tween.getName() == null || !tween.getName().equals(name)) continue;
            return tween;
        }
        return null;
    }

    public J3434 getTween(int index) {
        if (index < 0 || index >= this.tweens.size()) {
            return null;
        }
        return this.tweens.get(index);
    }

    public void update(int delta) {
        if (!this.tweens.isEmpty()) {
            for (J3434 tween : this.tweens) {
                if (tween.isActive()) {
                    tween.update(delta);
                }
                if (!tween.isFinished()) continue;
                tween.finish();
            }
        }
    }

    public void start() {
        for (J3434 tween : this.tweens) {
            tween.reset();
            tween.setActive(true);
        }
    }

    public void pause() {
        for (J3434 tween : this.tweens) {
            tween.setActive(false);
        }
    }

    public void reset() {
        this.start();
    }
}

