/*
 * Decompiled with CFR 0.152.
 */
package ds343gf;

import org.newdawn.slick.util.Log;

public class H3423t {
    private static double PI = Math.PI;
    private static double PI2 = 1.5707963267948966;
    private static double EL = 2.0 * PI / 0.45;
    private static double B1 = 0.36363636363636365;
    private static double B2 = 0.7272727272727273;
    private static double B3 = 0.5454545454545454;
    private static double B4 = 0.9090909090909091;
    private static double B5 = 0.8181818181818182;
    private static double B6 = 0.9545454545454546;
    public static final int NONE = -1;
    public static final int QUAD_IN = 0;
    public static final int QUAD_OUT = 1;
    public static final int QUAD_IN_OUT = 2;
    public static final int CUBE_IN = 3;
    public static final int CUBE_OUT = 4;
    public static final int CUBE_IN_OUT = 5;
    public static final int QUART_IN = 6;
    public static final int QUART_OUT = 7;
    public static final int QUART_IN_OUT = 8;
    public static final int QUINT_IN = 9;
    public static final int QUINT_OUT = 10;
    public static final int QUINT_IN_OUT = 11;
    public static final int SINE_IN = 12;
    public static final int SINE_OUT = 13;
    public static final int SINE_IN_OUT = 14;
    public static final int BOUNCE_IN = 15;
    public static final int BOUNCE_OUT = 16;
    public static final int BOUNCE_IN_OUT = 17;
    public static final int CIRC_IN = 18;
    public static final int CIRC_OUT = 19;
    public static final int CIRC_IN_OUT = 20;
    public static final int EXPO_IN = 21;
    public static final int EXPO_OUT = 22;
    public static final int EXPO_IN_OUT = 23;
    public static final int BACK_IN = 24;
    public static final int BACK_OUT = 25;
    public static final int BACK_IN_OUT = 26;

    public static float quadIn(float t) {
        return t * t;
    }

    public static float quadOut(float t) {
        return -t * (t - 2.0f);
    }

    public static float quadInOut(float t) {
        return (double)t <= 0.5 ? t * t * 2.0f : 1.0f - (t -= 1.0f) * t * 2.0f;
    }

    public static float cubeIn(float t) {
        return t * t * t;
    }

    public static float cubeOut(float t) {
        return 1.0f + (t -= 1.0f) * t * t;
    }

    public static float cubeInOut(float t) {
        return (double)t <= 0.5 ? t * t * t * 4.0f : 1.0f + (t -= 1.0f) * t * t * 4.0f;
    }

    public static float quartIn(float t) {
        return t * t * t * t;
    }

    public static float quartOut(float t) {
        return 1.0f - (t -= 1.0f) * t * t * t;
    }

    public static float quartInOut(float t) {
        double d;
        if ((double)t <= 0.5) {
            d = t * t * t * t * 8.0f;
        } else {
            t = t * 2.0f - 2.0f;
            d = (double)((1.0f - t * t * t * t) / 2.0f) + 0.5;
        }
        return (float)d;
    }

    public static float quintIn(float t) {
        return t * t * t * t * t;
    }

    public static float quintOut(float t) {
        return (t -= 1.0f) * t * t * t * t + 1.0f;
    }

    public static float quintInOut(float t) {
        float f;
        t *= 2.0f;
        return f < 1.0f ? t * t * t * t * t / 2.0f : ((t -= 2.0f) * t * t * t * t + 2.0f) / 2.0f;
    }

    public static float sineIn(float t) {
        return (float)(-Math.cos(PI2 * (double)t) + 1.0);
    }

    public static float sineOut(float t) {
        return (float)Math.sin(PI2 * (double)t);
    }

    public static float sineInOut(float t) {
        return (float)(-Math.cos(PI * (double)t) / 2.0 + 0.5);
    }

    public static float bounceIn(float t) {
        if ((double)(t = 1.0f - t) < B1) {
            return (float)(1.0 - 7.5625 * (double)t * (double)t);
        }
        if ((double)t < B2) {
            return (float)(1.0 - (7.5625 * ((double)t - B3) * ((double)t - B3) + 0.75));
        }
        if ((double)t < B4) {
            return (float)(1.0 - (7.5625 * ((double)t - B5) * ((double)t - B5) + 0.9375));
        }
        return (float)(1.0 - (7.5625 * ((double)t - B6) * ((double)t - B6) + 0.984375));
    }

    public static float bounceOut(float t) {
        if ((double)t < B1) {
            return (float)(7.5625 * (double)t * (double)t);
        }
        if ((double)t < B2) {
            return (float)(7.5625 * ((double)t - B3) * ((double)t - B3) + 0.75);
        }
        if ((double)t < B4) {
            return (float)(7.5625 * ((double)t - B5) * ((double)t - B5) + 0.9375);
        }
        return (float)(7.5625 * ((double)t - B6) * ((double)t - B6) + 0.984375);
    }

    public static float bounceInOut(float t) {
        if ((double)t < 0.5) {
            if ((double)(t = 1.0f - t * 2.0f) < B1) {
                return (float)((1.0 - 7.5625 * (double)t * (double)t) / 2.0);
            }
            if ((double)t < B2) {
                return (float)((1.0 - (7.5625 * ((double)t - B3) * ((double)t - B3) + 0.75)) / 2.0);
            }
            if ((double)t < B4) {
                return (float)((1.0 - (7.5625 * ((double)t - B5) * ((double)t - B5) + 0.9375)) / 2.0);
            }
            return (float)((1.0 - (7.5625 * ((double)t - B6) * ((double)t - B6) + 0.984375)) / 2.0);
        }
        if ((double)(t = t * 2.0f - 1.0f) < B1) {
            return (float)(7.5625 * (double)t * (double)t / 2.0 + 0.5);
        }
        if ((double)t < B2) {
            return (float)((7.5625 * ((double)t - B3) * ((double)t - B3) + 0.75) / 2.0 + 0.5);
        }
        if ((double)t < B4) {
            return (float)((7.5625 * ((double)t - B5) * ((double)t - B5) + 0.9375) / 2.0 + 0.5);
        }
        return (float)((7.5625 * ((double)t - B6) * ((double)t - B6) + 0.984375) / 2.0 + 0.5);
    }

    public static float circIn(float t) {
        return (float)(-(Math.sqrt(1.0f - t * t) - 1.0));
    }

    public static float circOut(float t) {
        return (float)Math.sqrt(1.0f - (t - 1.0f) * (t - 1.0f));
    }

    public static float circInOut(float t) {
        return (float)((double)t <= 0.5 ? (Math.sqrt(1.0f - t * t * 4.0f) - 1.0) / -2.0 : (Math.sqrt(1.0f - (t * 2.0f - 2.0f) * (t * 2.0f - 2.0f)) + 1.0) / 2.0);
    }

    public static float expoIn(float t) {
        return (float)Math.pow(2.0, 10.0f * (t - 1.0f));
    }

    public static float expoOut(float t) {
        return (float)(-Math.pow(2.0, -10.0f * t) + 1.0);
    }

    public static float expoInOut(float t) {
        return (float)((double)t < 0.5 ? Math.pow(2.0, 10.0f * (t * 2.0f - 1.0f)) / 2.0 : (-Math.pow(2.0, -10.0f * (t * 2.0f - 1.0f)) + 2.0) / 2.0);
    }

    public static float backIn(float t) {
        return (float)((double)(t * t) * (2.70158 * (double)t - 1.70158));
    }

    public static float backOut(float t) {
        return (float)(1.0 - (double)((t -= 1.0f) * t) * (-2.70158 * (double)t - 1.70158));
    }

    public static float backInOut(float t) {
        if ((t *= 2.0f) < 1.0f) {
            return (float)((double)(t * t) * (2.70158 * (double)t - 1.70158) / 2.0);
        }
        t -= 1.0f;
        return (float)((1.0 - (double)((t -= 1.0f) * t) * (-2.70158 * (double)t - 1.70158)) / 2.0 + 0.5);
    }

    public static String getName(int easeFunction) {
        switch (easeFunction) {
            case 0: {
                return "QUAD_IN";
            }
            case 1: {
                return "QUAD_OUT";
            }
            case 2: {
                return "QUAD_IN_OUT";
            }
            case 3: {
                return "CUBE_IN";
            }
            case 4: {
                return "CUBE_OUT";
            }
            case 5: {
                return "CUBE_IN_OUT";
            }
            case 6: {
                return "QUART_IN";
            }
            case 7: {
                return "QUART_OUT";
            }
            case 8: {
                return "QUART_IN_OUT";
            }
            case 9: {
                return "QUINT_IN";
            }
            case 10: {
                return "QUINT_OUT";
            }
            case 11: {
                return "QUINT_IN_OUT";
            }
            case 12: {
                return "SINE_IN";
            }
            case 13: {
                return "SINE_OUT";
            }
            case 14: {
                return "SINE_IN_OUT";
            }
            case 15: {
                return "BOUNCE_IN";
            }
            case 16: {
                return "BOUNCE_OUT";
            }
            case 17: {
                return "BOUNCE_IN_OUT";
            }
            case 18: {
                return "CIRC_IN";
            }
            case 19: {
                return "CIRC_OUT";
            }
            case 20: {
                return "CIRC_IN_OUT";
            }
            case 21: {
                return "EXPO_IN";
            }
            case 22: {
                return "EXPO_OUT";
            }
            case 23: {
                return "EXPO_IN_OUT";
            }
            case 24: {
                return "BACK_IN";
            }
            case 25: {
                return "BACK_OUT";
            }
            case 26: {
                return "BACK_IN_OUT";
            }
        }
        Log.warn("Easing function not mapped " + easeFunction);
        return "NONE";
    }

    public static float ease(int easeFunction, float t) {
        switch (easeFunction) {
            case 0: {
                return H3423t.quadIn(t);
            }
            case 1: {
                return H3423t.quadOut(t);
            }
            case 2: {
                return H3423t.quadInOut(t);
            }
            case 3: {
                return H3423t.cubeIn(t);
            }
            case 4: {
                return H3423t.cubeOut(t);
            }
            case 5: {
                return H3423t.cubeInOut(t);
            }
            case 6: {
                return H3423t.quartIn(t);
            }
            case 7: {
                return H3423t.quartOut(t);
            }
            case 8: {
                return H3423t.quartInOut(t);
            }
            case 9: {
                return H3423t.quintIn(t);
            }
            case 10: {
                return H3423t.quintOut(t);
            }
            case 11: {
                return H3423t.quintInOut(t);
            }
            case 12: {
                return H3423t.sineIn(t);
            }
            case 13: {
                return H3423t.sineOut(t);
            }
            case 14: {
                return H3423t.sineInOut(t);
            }
            case 15: {
                return H3423t.bounceIn(t);
            }
            case 16: {
                return H3423t.bounceOut(t);
            }
            case 17: {
                return H3423t.bounceInOut(t);
            }
            case 18: {
                return H3423t.circIn(t);
            }
            case 19: {
                return H3423t.circOut(t);
            }
            case 20: {
                return H3423t.circInOut(t);
            }
            case 21: {
                return H3423t.expoIn(t);
            }
            case 22: {
                return H3423t.expoOut(t);
            }
            case 23: {
                return H3423t.expoInOut(t);
            }
            case 24: {
                return H3423t.backIn(t);
            }
            case 25: {
                return H3423t.backOut(t);
            }
            case 26: {
                return H3423t.backInOut(t);
            }
        }
        Log.warn("Easing function not mapped " + easeFunction);
        return 0.0f;
    }
}

