#include <windows.h>
#include <vector>
#include <stdio.h>
#include <string.h>

class Parent
{
    public:
    int alarm[2];
    virtual void alarm0(){}
    virtual void alarm1(){}
	// wsprzdne obiektu
	int x, y;
	// prdko
	int hspeed, vspeed;
	// czy ma by wywietlony
	bool show;
	// obrt
	float direction;
	// konstruktor
	Parent():x(0), y(0), hspeed(0), vspeed(0), direction(0), show(true){}
	Parent(int _x, int _y):x(_x), y(_y)
	{
	    hspeed = vspeed = 0;
	    direction = 0.0f;
	    show = true;
    }
	// destruktor
	virtual ~Parent(){};
	// bdzie uruchamiany na pocztku obiektu tylko raz
	// virtual powoduje e mona funkcj mona zdefiniowa na nowo
	virtual void create(){}
	// bdzie pracowa do zakoczenia programu
	virtual void step(){}
	// t funkcje niebdzie mona zmieni w nowym obiekcie
	void step_begin()
	{
	    x += hspeed;
	    y += vspeed;
    }
	// rysuje nasz objekt
	virtual void draw()
    {
        //draw_sprite(current_sprite, image_number, x, y);
    }
};

class objects0 : public Parent
{
	public:
	void create()
	{
		alarm[0] = 30;
		printf("Create Object 0\n");
    }
    void alarm0()
    {
        x+=30;
        alarm[1] = 30;
        printf("objects0 x: %d\n", x);
    }
    void alarm1()
    {
        x -= 30;
        alarm[0] = 30;
        printf("objects0 x: %d\n", x);
    }
};

class objects1 : public Parent
{
	public:
	void step()
	{
		y++;
		printf("objects1 step\n");
	}

    void draw()
    {
        // draw_point(x, y);
    }
};

class MapaParent
{
    //tutaj trzymamy nasze objekty
    // mona skoysta z innych struktur, i chyba najlepszym jest lista
    // ale urzyj vectora bo jest moim zdaniem prosty w obsudze
    std::vector<Parent*> obj;
    int id;
    public:
	MapaParent():obj(NULL), id(0){}
	virtual ~MapaParent(){};

	void instance_create(int x, int y, Parent *_obj)
	{
	    obj.push_back(_obj);
	    obj[id]->x = x;
	    obj[id++]->y = y;
	}

	void create()
	{
	    // rysuje objekty mapy
	    for(int i = 0; i<obj.size(); i++)
	    {
            obj[i]->create();
	    }
	}

	void step()
	{
	    for(int i = 0; i<obj.size(); i++)
	    {
	        obj[i]->step_begin();
	        // przetwarza alarmy, czyli funkcje uruchamiane po
            // pewnych ilociach cykli, w tym przypadku ustalanych w alarmach.
	        for(int a = 0; a<2; a++)
	        {
	            if(obj[i]->alarm[a] >= 0)
	            {
	                obj[i]->alarm[a]--;
	            }
	            if(obj[i]->alarm[a] == 0)
	            {
	                switch(a)
	                {
	                    case 0: obj[i]->alarm0(); obj[i]->alarm[a] = -1; break;
	                    case 1: obj[i]->alarm1(); obj[i]->alarm[a] = -1; break;
	                    //...
	                }
	            }
	        }
	        // przetwarza step
            obj[i]->step();
	    }
	}

	void draw()
	{
	    // rysuje objekty mapy
	    for(int i = 0; i<obj.size(); i++)
	    {
	        if(obj[i]->show)
                obj[i]->draw();
	    }
	}
};

class Mapa0 : public MapaParent
{
    public:
	Mapa0()
	{
	    // dodaje objekt do vactora
		instance_create(100, 100, new objects0);
		instance_create(200, 100, new objects1);
		//instance_create(300, 100, new objects0);
    }
};

int main()
{
    Mapa0 * map = new Mapa0();
    map->create();
    for(int i = 0; i<100; i++)
    {
        map->step();
        map->draw();
    }
    system("pause");
    return 0;
}
