#include <stdlib.h>
#include <pthread.h>
#include <stdio.h>
#include <sys/timeb.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>

#define MAX_CLIENT_PER_THREAD 300
#define MAX_THREAD 1
#define PORT 7175
#define MAX_CLIENT_BUFFER 16384
#define DEBUG

enum PacketsKurwa {
	// klient
	pHello = 0x01, // powitanie od klienta
		pClient = 0x02, // widz
		pHost   = 0x03, // caster

	pGamePacket   = 0x64, // pakiet gry
	pChatMessage  = 0x32, // pakiet wiadomosci

	// serwer
	pWelcome     = 0x09, // id przypisane do polaczenia
	pHelloError  = 0x08, // blad przypisania id (error ogolny)
	pTryAgain    = 0x07 // sproboj ponownie generowac ID
};

typedef unsigned char pChar;

typedef struct {

    int ClientSock;

    int ClientID;
	int HostID;
    int isHost;

	int Slots;
	int SlotMax;

} StructClients;

typedef struct {
	pthread_t tid;
	int client_count;
	StructClients clients[MAX_CLIENT_PER_THREAD];
} Thread;

pthread_cond_t new_connection_cond = PTHREAD_COND_INITIALIZER;
pthread_mutex_t new_connection_mutex = PTHREAD_MUTEX_INITIALIZER;

// zmienne globalne
Thread threads[MAX_THREAD];
int listenfd;
int sizepos;

pChar GetByte(pChar buffer[MAX_CLIENT_BUFFER], int *position)
{
	pChar ret;
	ret = buffer[*position];
	*position = *position + 1;
	return ret;
}

int GetU16(pChar buffer[MAX_CLIENT_BUFFER], int *position)
{
	int ret;
	ret = (buffer[*position] | (buffer[*position + 1] << 8));
	*position = *position + 2;
	return ret;
}

long long int GetU32(pChar buffer[MAX_CLIENT_BUFFER], int *position)
{
	long long int ret;
	ret = (buffer[*position] | (buffer[*position + 1] << 8) |
						        (buffer[*position + 2] << 16) |
						        (buffer[*position + 3] << 24));
	*position = *position + 4;
	return ret;
}

void PutByte(pChar byte, pChar *buffer[MAX_CLIENT_BUFFER], int *position)
{
    *buffer[*position] = byte;
    *position = *position + 1;
}

void PutU16(int integer, pChar *buffer[MAX_CLIENT_BUFFER], int *position)
{
    *buffer[*position] = (pChar)integer;
    *buffer[*position] = (pChar)(integer >> 8);
    *position = *position + 1;
}

void SendPacket(int cSock, pChar buffer[MAX_CLIENT_BUFFER], int length)
{
	send(cSock, buffer, length, 0);
}

void ParsePacket(StructClients *client, pChar packet[MAX_CLIENT_BUFFER], int length)
{
	pChar sBuffer[MAX_CLIENT_BUFFER];
	int sLength, pLength;
	pChar PacketID, HelloType;

	sizepos = 0;
	pLength = GetU16(packet, &sizepos);

	PacketID = GetByte(packet, &sizepos);
	switch (PacketID)
	{

		case pHello:
			HelloType = GetByte(packet, &sizepos);
			if (HelloType == pClient)
			{
				client->ClientID = GetU16(packet, &sizepos);
				client->HostID = GetU16(packet, &sizepos);

				client->isHost = 0;
			}
			else
			{

				client->ClientID = GetU16(packet, &sizepos);
				client->HostID = GetU16(packet, &sizepos);


				client->isHost = 1;
			}
			sBuffer[0] = 0x01;
			sBuffer[1] = 0x00;
			sBuffer[2] = pWelcome;
			sLength = 3;
			SendPacket(client->ClientSock, sBuffer, sLength);
#ifdef DEBUG
			printf(\"Pakiet Hello odebrany (Typ: %d [1 host, 0 client], ClientID: %d, HostID: %d), Welcome wyslane!\\n\", client->isHost, client->ClientID, client->HostID);
#endif
		break;

		case pGamePacket:

		break;

		case pChatMessage:

		break;

		default:
#ifdef DEBUG
			printf(\"Nieznany typ pakietu: %d\\n\", PacketID);
#endif
		break;
	}

}

// funkcja resetujaca strukture klienta
void resetStructClient(StructClients *client)
{
	client->ClientSock = 0;

	/*int i;
	for (i = 0; i < 7; i++)
	{
		client->ClientID[i] = 0x00;
		client->HostID[i] = 0x00;
	}*/
	client->ClientID = 0;
	client->HostID = 0;

	client->isHost = 0;
	client->Slots = 0;
	client->SlotMax = 0;
}

// tryb nie blokujacy
void nonblock(int sockfd)
{
	int opts;
	opts = fcntl(sockfd, F_GETFL);
	if(opts < 0)
	{
		perror(\"fcntl(F_GETFL)\\n\");
		exit(1);
	}
	opts = (opts | O_NONBLOCK);
	if(fcntl(sockfd, F_SETFL, opts) < 0)
	{
		perror(\"fcntl(F_SETFL)\\n\");
		exit(1);
	}
}

// thread/y
void *thread_init_func(void *arg)
{
	int tid = (int) arg;

	int readsocks;
	int i;
	pChar buffer[MAX_CLIENT_BUFFER];
	char c;
	int len;

#ifdef DEBUG
	printf(\"thread %d created\\n\", tid);
	printf(\"sizeof thread.clients: %d\\n\", sizeof(threads[tid].clients));
#endif

	memset((int *) &threads[tid].clients, 0, sizeof(threads[tid].clients));
	memset((pChar *) &buffer, 0, sizeof(buffer));
	while(1)
	{
#ifdef DEBUG
		printf(\"thread %d running, client count: %d\\n\", tid, threads[tid].client_count);
		sleep(3);
#endif
		sleep(1); /* <-- it works ??? :-| */

		for(i = 0; i < MAX_CLIENT_PER_THREAD; i++)
		{
			if(threads[tid].clients[i].ClientSock != 0)
			{
				len = recv(threads[tid].clients[i].ClientSock, buffer, MAX_CLIENT_BUFFER, 0);
				if(len == 0)
				{
#ifdef DEBUG
					printf(\"client %d closed connection 0\\n\", threads[tid].clients[i].ClientSock);
#endif
					//threads[tid].clients[i].ClientSock = 0;
					resetStructClient(&threads[tid].clients[i]);
					threads[tid].client_count--;

					memset((pChar *) &buffer, 0, sizeof(buffer));
				}
				else if(len < 0)
				{
					if(errno == EAGAIN)
					{
#ifdef DEBUG
						printf(\"errno: EAGAIN\\n\");
#endif
					}
					else {
#ifdef DEBUG
						printf(\"errno: %d\\n\", errno);
#endif
						//threads[tid].clients[i].ClientSock = 0;
						resetStructClient(&threads[tid].clients[i]);
						threads[tid].client_count--;

						memset( (pChar *) &buffer, 0, sizeof(buffer));
#ifdef DEBUG
						printf(\"client %d closed connection -1\\n\", threads[tid].clients[i].ClientSock);
#endif
					}
				}
				else {
#ifdef DEBUG
					printf(\"%d bytes received from %d - %s\\n\", len, threads[tid].clients[i].ClientSock, buffer);
#endif

					//send(threads[tid].clients[i].ClientSock, buffer, strlen(buffer), 0);

					ParsePacket(&threads[tid].clients[i], buffer, len);

					memset((pChar *) &buffer, 0, sizeof(buffer));
				}
			}
		}
	}
}

int choose_thread()
{
	int i=MAX_THREAD-1;
	int min = 0;
	while(i > -1)
	{
		if(threads[i].client_count < threads[i-1].client_count)
		{
			min = i;
			break;
		}
		i--;
	}
	return min;
}

int main()
{
	char c;
	struct sockaddr_in srv, cli;
	int clifd;
	int tid;
	int i;
	int choosen;

	signal(SIGPIPE, SIG_IGN);

	// tworzenie socketa
	if( (listenfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror(\"sockfd\\n\");
		exit(1);
	}

	// zerujemy bufor i konfigurujemy server
	bzero(&srv, sizeof(srv));
	srv.sin_family = AF_INET;
	srv.sin_addr.s_addr = INADDR_ANY;
	srv.sin_port = htons(PORT);

	//bindowanie konfiguracji z serverem
	if( bind(listenfd, (struct sockaddr *) &srv, sizeof(srv)) < 0)
	{
		perror(\"bind\\n\");
		exit(1);
	}

	// nasluchiwanie
	listen(listenfd, 1024);


	/* tworzenie watkow */
	for(i = 0; i < MAX_THREAD; i++)
	{
		pthread_create(&threads[i].tid, NULL, &thread_init_func, (void *) i);
		threads[i].client_count = 0;
	}

    int laddr_len;

	// nieskonczona petla do akceptacji klientow
	for( ; ; )
	{
		clifd = accept(listenfd, (struct sockaddr *) &cli, &laddr_len); // akceptujemy
		nonblock(clifd);  // ustawiamy tryb nieblokujacy
#ifdef DEBUG
        printf(\"Polaczenie z adresu ip: %s\\n\", (char *)inet_ntoa(cli.sin_addr));
#endif
		pthread_mutex_lock(&new_connection_mutex);

		choosen = choose_thread();

		for(i = 0; i < MAX_CLIENT_PER_THREAD; i++)
		{
			if(threads[choosen].clients[i].ClientSock == 0)
			{
#ifdef DEBUG
				printf(\"before threads clifd\\n\");
#endif
				threads[choosen].clients[i].ClientSock = clifd;
#ifdef DEBUG
				printf(\"after threads clifd\\n\");
#endif
				threads[choosen].client_count++;
				break;
			}
		}

#ifdef DEBUG
		printf(\"choosen: %d\\n\", choosen);

		for(i = 0; i < MAX_THREAD; i++)
		{
			printf(\"threads[%d].client_count:%d\\n\", i, threads[i].client_count);
		}
#endif

		pthread_mutex_unlock(&new_connection_mutex);
	}

	if(errno)
	{
		printf(\"errno: %d\", errno);
	}

	return 0;
}
