#ifdef __cplusplus
#define ddlexport extern "C" __declspec( dllexport )
#else
#define ddlexport __declspec( dllexport )
#endif

#include "stdafx.h"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>

using namespace std;

static const char *error_wrong_number = "Wrong number of arguments to function or script.\n";
static const char *error_unknown_variable = "Unknown variable: ";
static const char *error_negative_argument = "Negative function argument size\n";
static const char *error_unexpected_symbol = "Unexpected symbol: ";

typedef string (*Sfunc)();

struct FUNCTION
{
	string name;
	int size;
};

struct struct2string
{
	string name;
	string name2;
};

int new_fsize = 0;
bool function_start = false;
vector<FUNCTION> function_list;
vector<string> line_code;
map<string, Sfunc> list;
map<string, string> var;
map<int, struct2string> fmap;

map<string, string> var_local;
map<string, string> var_string;
vector<string> arg;
string str, last_error, fcode = "", akt_function = "";

bool is_operator(string& st)
{
	return (st == "+=" || st == "-=" || st == "/=" || st == "*=" || st == "="
			|| st == "+" || st == "-" || st == "/" || st == "*" || st == "%");
}

bool is_operator(char c)
{
	return (c == '+' || c == '-' || c == '/' || c == '*' || c == '=' || c == '%');
}

bool is_let(char c)
{
	return (c>='a'&&c<='z'||c>='A'&&c<='Z');
}

bool is_let(const string& s)
{
	int size = s.length();
	for(int i = 0; i< size; i++)
	{
		if(!is_let(s[i])) return false;
	}
	return true;
}

bool is_dig(char c)
{
	return (c>='0'&&c<='9');
}

bool is_dig(const string& s)
{
	int size = s.length();
	for(int i = 0; i< size; i++)
	{
		if(!is_dig(s[i])) return false;
	}
	return true;
}

bool is_let_dig(const string& s)
{
	int size = s.length();
	for(int i = 0; i< size; i++)
	{
		if(!is_dig(s[i]) || !is_let(s[i]) || s[i] != '_') return false;
	}
	return true;
}

bool is_let_dig_opr(const string& s)
{
	int size = s.length();
	for(int i = 0; i< size; i++)
	{
		if(!is_dig(s[i]) || !is_let(s[i]) || s[i] != '_' || !is_operator(s[i])) return false;
	}
	return true;
}

const char* WS_SET = " \t\r\n\0";
string cword;
bool get_text()
{
	 const char* CHAR_QUOTE = "\"";
	 size_t pos = 0, pos2;
	 pos = (unsigned)str.find_first_not_of(WS_SET, pos);
	 if(pos == string::npos) return false;
	 cword = str.substr(pos, 1);
	 if(cword != CHAR_QUOTE) return false;
	 pos = str.find_first_not_of(CHAR_QUOTE, pos);
	 if(pos == string::npos) return false;
	 pos2 = str.find_first_of(CHAR_QUOTE, pos+1);
	 if(pos2 == string::npos) return false;
	 cword = str.substr(pos, pos2-pos);
	 pos = str.find_first_of(WS_SET, pos2);
	 if(pos == string::npos) pos = str.size()-1;
	 return true;
}

string get_sring()
{
	string t;
	size_t pos = str.find_first_not_of(WS_SET, 0);
	if(pos == string::npos)
	{
		return "";
	}

	size_t pos2 = str.find_first_of(WS_SET, pos);
	if(pos2 == string::npos)
	{
		pos = str.length()-1;
		t = str.substr(pos, str.length()-pos);
		str.erase(0, str.length()-pos);
		return t;
	}
	else
		t = str.substr(pos, pos2-pos);
	str.erase(0, pos2);
	return t;
}

string get_sring2()
{
	string t;
	size_t pos = str.find_first_not_of(WS_SET, 0);
	if(pos == string::npos)
	{
		return "";
	}

	size_t pos2 = str.find_first_of(WS_SET, pos);
	if(pos2 == string::npos)
	{
		pos = str.length()-1;
		t = str.substr(pos, str.length()-pos);
		str.erase(0, str.length()-pos);
		return t;
	}
	else
		t = str.substr(pos, pos2-pos);
	return t;
}


string Parsestring()
{
	string temp, t2;
	if(get_text())
		return "\""+cword+"\"";
	temp = get_sring();
	if (is_let_dig_opr(temp))
	{
		last_error.append(error_unexpected_symbol+temp+"\n");
		return "";
	}

	if (function_start)
	{
		int size = (int)arg.size();
		for(int i = 0; i<size; i++)
			if (arg[i] == temp) return temp;
	}
	if(list[temp] != 0)
		return list[temp]();
	if(var[temp] != "")
	{
		return var[temp];
	}
	if(var_string[temp] != "")
		return "\""+var_string[temp]+"\"";
	if(var_local[temp] != "")
	{
		t2 = get_sring2();
		if(is_operator(t2))
		{
			get_sring();
			return temp+t2+Parsestring();
		}
		return temp;
	}

	int Size = (int)function_list.size();
	for(int i = 0; i< Size; i++)
	{
		if (function_list[i].name == temp)
		{
			int size = function_list[i].size;
			//if (!size) return "execute_string(variable_global_get('"+temp+"'), 0)";
			if (!size) return "execute_string("+temp+", 0)";
			else
			{
				t2 = "";
				for(int j = 0; j<size; j++)
				{
					string t3 = Parsestring();
					t2 += ","+t3;
					if (t3 == "")
					{
						last_error.append(error_wrong_number);
					}
				}
				//return "execute_string(variable_global_get('"+temp+"')"+t2+")";
				return "execute_string("+temp+t2+")";
			}
		}
	}

	if(is_operator(temp))
	{
		return temp;
	}
	for(unsigned i = 0; i<temp.size();i++)
	{
		if(!is_dig(temp[i]))
		{
			last_error.append(error_unknown_variable+temp+"\n");
			return "";
		}
	}
	return temp;
}

void load_string(const char* fname)
{
	string line = "";
	fstream plik;
	plik.open(fname);
	int open = 0;
	char c = ' ', c1 = ' ';
	for(;;)
	{
		char com = 0;
		c = (char)plik.get();
		if (c == '"') open = !open;
		if (!open)
		{
			if (c == ';') c = '\n';
		}
		if (c == '/')
		{
			c1 = (char)plik.get();
			if (c1 == '/')
			{
				for(;;)
				{
					c = (char)plik.get();
					if (c == '\n' || c == '\0')
						break;
				}
			}
			else
				com = 1;
			line += c;
		}
		if (com == 1)
		{
			com = 0;
			line += c1;
		}
		line += c;
		if (c == '\n' || plik.eof())
		{
			line_code.push_back(line);
			line.clear();
		}
		if(plik.eof()) break;
	}
	line = "\n";
	line_code.push_back(line);
}

string get_param(const string& name, int size)
{
	string s = name+"(";
	if(size>0) s += Parsestring();
	for(int i = 1; i<size;i++)
	{
		string param = Parsestring();
		if (param == "")
		{
			last_error.append(error_wrong_number);
			param = "0";
		}
		s.append(","+param);
	}
	return s+")";
}

string f_lengthdir_x()		{return get_param("lengthdir_x", 2);}
string f_lengthdir_y()		{return get_param("lengthdir_y", 2);}
string f_abs()				{return get_param("abs", 1);}
string f_random()			{return get_param("random", 1);}
string f_sign() 			{return get_param("sign", 1);}
string f_round() 			{return get_param("round", 1);}
string f_floor() 			{return get_param("floor", 1);}
string f_ceil() 			{return get_param("ceil", 1);}
string f_frac()				{return get_param("frac", 1);}
string f_sqrt()				{return get_param("sqrt", 1);}
string f_sqr()				{return get_param("sqr", 1);}
string f_power()			{return get_param("power", 1);}
string f_exp()				{return get_param("exp", 1);}
string f_ln()				{return get_param("ln", 1);}
string f_log2()				{return get_param("log2", 1);}
string f_log10()			{return get_param("log10", 1);}
string f_logn()				{return get_param("logn", 2);}
string f_sin()				{return get_param("sin", 1);}
string f_cos()				{return get_param("cos", 1);}
string f_tan()				{return get_param("tan", 1);}
string f_arcsin()			{return get_param("arcsin", 1);}
string f_arccos()			{return get_param("arccos", 1);}
string f_arctan()			{return get_param("arctan", 1);}
string f_arctan2()			{return get_param("arctan2", 2);}
string f_degtorad()			{return get_param("degtorad", 2);}
string f_radtodeg()			{return get_param("radtodeg", 2);}
string f_min2()				{return get_param("min", 2);}
string f_min3()				{return get_param("min", 3);}
string f_max2()				{return get_param("max", 2);}
string f_max3()				{return get_param("max", 3);}
string f_mean2()			{return get_param("mean", 2);}
string f_mean3()			{return get_param("mean", 3);}
string f_median2()			{return get_param("median", 2);}
string f_median3()			{return get_param("median", 3);}
string f_distance()			{return get_param("point_distance", 4);}
string f_direction()		{return get_param("point_direction", 4);}
string f_rgb()				{return get_param("make_color_rgb", 3);}
string f_hsv()				{return get_param("make_color_hsv", 3);}
string f_merge_color()		{return get_param("merge_color", 2);}
string f_getpixel()			{return get_param("draw_getpixel", 2);}
string f_text_get_char()	{return get_param("string_char_at", 2);}
string f_text_copy()		{return get_param("string_copy", 3);}
string f_text_count()		{return get_param("string_count", 2);}
string f_text_delete()		{return get_param("string_delete", 3);}
string f_text_insert()		{return get_param("string_insert", 3);}
string f_text_digits()		{return get_param("string_digits", 1);}
string f_text_height()		{return get_param("string_height", 1);}
string f_text_width()		{return get_param("string_width", 1);}
string f_text_length()		{return get_param("string_length", 1);}
string f_print()			{return get_param("draw_text", 3);}
string f_clear()			{return get_param("draw_clear", 1);}
string f_alpha()			{return get_param("draw_set_alpha", 1);}
string f_line_color()		{return get_param("draw_line_color", 6);}
string f_line_width()		{return get_param("draw_line_width", 5);}
string f_line_width_color()	{return get_param("draw_line_width_color", 7);}
string f_point()			{return get_param("draw_point", 2);}
string f_point_color()		{return get_param("draw_point_color", 3);}
string f_circle()			{return get_param("draw_circle", 4);}
string f_circle_color()		{return get_param("draw_circle_color", 6);}
string f_ellipse()			{return get_param("draw_ellipse", 5);}
string f_ellipse_color()	{return get_param("draw_ellipse_color", 7);}
string f_line()				{return get_param("draw_line", 4);}
string f_color()			{return get_param("draw_set_color", 1);}
string f_rectangle()		{return get_param("draw_rectangle", 5);}
string f_rectangle_color()	{return get_param("draw_rectangle_color", 9);}
string f_roundrect()		{return get_param("draw_roundrect", 5);}
string f_roundrect_color()	{return get_param("draw_roundrect_color", 9);}
string f_arrow()			{return get_param("draw_arrow", 5);}
string f_vertex()			{return get_param("draw_vertex", 2);}
string f_vertex_color()		{return get_param("draw_vertex", 4);}
string f_triangle()			{return get_param("draw_triangle", 7);}
string f_triangle_color()	{return get_param("f_triangle_color", 10);}
string f_primitive_end()	{return "draw_primitive_end()";}
string f_print_color()		{return get_param("draw_text_color", 8);}
string f_bbegin()			{return "{";}
string f_bend()				{return "}";}
string f_else()				{return "else ";}
string f_exit()				{return "game_end()";}
string f_repeat()			{return get_param("repeat", 1);}
string f_message()			{return get_param("show_message", 1);}
string f_continue()			{return "continue;";}
string f_switch()			{return get_param("switch", 1);}
string f_do()				{return "do ";}
string f_case()				{return "case "+Parsestring()+":";}
string f_default()			{return "default:";}
string f_break()			{return "break;";}
string f_primitive_begin()	{return get_param("draw_primitive_begin", 1);}
string f_return()			{return get_param("return", 1);}

string f_if()
{
	string str, t;
	str = "if("+Parsestring()+" ";
	t = Parsestring();
	str += t;
	if (!is_operator(t)) last_error.append("is not operator help:'if var0 operator var1'\n");
	return str+Parsestring()+") ";
}

string f_while()
{
	string str, t;
	
	str = "while("+Parsestring()+" ";
	t = Parsestring();
	str += t;
	if (!is_operator(t)) last_error.append("is not operator help:'while var0 operator var1'\n");
	return str+Parsestring()+" ";
}

bool is_new_function(const string& s)
{
	for(int i = 0; i<new_fsize;i++)
	{
		return (fmap[i].name == s);
	}
	return false;
}
string f_var()
{
	string temp = get_sring();
	string param = Parsestring();
	if(var_local[temp] == "" && var[temp] == "" && list[temp] == 0 && !is_new_function(temp) && var_string[temp] == "") 
	{
		var_local[temp] = param;
		return temp+" = "+param;
	}
	return "";
}

string f_function()
{
	function_start = true;
	string temp = get_sring();
	akt_function = temp;
	FUNCTION funct;
	if(var_local[temp] == "" && var[temp] == "" && list[temp] == 0 && !is_new_function(temp) && var_string[temp] == "") 
	{
		funct.name = temp;
		int size = atoi(Parsestring().c_str());
		if (size < 0)
		{
			last_error.append(error_negative_argument);
			funct.size = 0;
			return "";
		}
		funct.size = size;
		for(int i = 0; i< size; i++)
		{
			temp = get_sring();
			if (temp == "")
			{
				last_error.append(error_wrong_number);
				function_start = false;
				return "";
			}
			arg.push_back(temp);
		}
		function_list.push_back(funct);
		return "";
	}
}

string f_end()
{
	struct2string fname;
	string temp = "";
	int Size = (int)function_list.size();
	for(int j = 0; j< Size; j++)
	{
		int size = (int)function_list[j].size;
		cout<<size<<endl;
		for(int i = 0; i< size; i++)
		{
			string x;
			x = (char)i+'0';
			temp.append(arg[i]+"=argument"+x+"\n");
		}
	}
	function_start = false;

	fmap[new_fsize].name = akt_function;
	fmap[new_fsize++].name2 = temp + fcode;
	akt_function = "";
	fcode = "";
	return "";
}

void find_var()
{
	var["true"]				= "1";
	var["false"]			= "0";
	var["pi"]				= "3.141592653589793238462643383279502884197169399375105820974944592";
	var["white"]			= "c_white";
	var["black"]			= "0";
	var["red"]				= "255";
	var["green"]			= "c_green";
	var["blue"]				= "c_blue";
	var["olive_green"]		= "4210688";
	var["dark_green"]		= "21760";
	var["dark_teal"]		= "6160384";
	var["dark_blue"]		= "9109504";
	var["indigo"]			= "8519755";
	var["gray"]				= "2631720";
	var["dark_red"]			= "139";
	var["orange"]			= "2124031";
	var["dark_yellow"]		= "35723";
	var["teal"]				= "9342520";
	var["blue_grey"]		= "12614523";
	var["gray40"]			= "6710886";
	var["light_orange"]		= "6008319";
	var["lime"]				= "3329330";
	var["sea_green"]		= "7451452";
	var["aqua"]				= "13959039";
	var["light_blue"]		= "12623485";
	var["violet"]			= "8388736";
	var["gray50"]			= "8355711";
	var["pink"]				= "13353215";
	var["gold"]				= "55295";
	var["yellow"]			= "65535";
	var["bright_green"]		= "65280";
	var["turquoise"]		= "13688896";
	var["sky_blue"]			= "16777152";
	var["plum"]				= "4718664";
	var["light_gray"]		= "12632256";
	var["rose"]				= "14804223";
	var["tan"]				= "9221230";
	var["light_yellow"]		= "16056319";
	var["pale_green"]		= "10025880";
	var["pale_turquoise"]	= "15658671";
	var["pale_blue"]		= "9143144";
	var["lavender"]			= "16443110";
	var["c_day"]			= "current_day";
	var["c_hour"]			= "current_hour";
	var["c_minute"]			= "current_minute";
	var["c_month"]			= "current_month";
	var["c_month"]			= "current_month";
	var["c_second"]			= "current_second";
	var["c_time"]			= "current_time";
	var["c_weekday"]		= "current_weekday";
	var["c_year"]			= "current_year";
	var["clipboard_get"]	= "clipboard_get_text()";
	var["linelist"]			= "pr_linelist";
	var["linestrip"]		= "pr_linestrip";
	var["pointlist"]		= "pr_pointlist";
	var["trianglefan"]		= "pr_trianglefan";
	var["trianglelist"]		= "pr_trianglelist";
	var["trianglestrip"]	= "pr_trianglestrip";
}

void find_function()
{
	list["line"]		= f_line;
	list["color"]		= f_color;
	list["lengthdir_x"] = f_lengthdir_x;
	list["lengthdir_y"] = f_lengthdir_y;
	list["random"]		= f_random;
	list["abs"]			= f_abs;
	list["sign"]		= f_sign;
	list["round"]		= f_round;
	list["floor"]		= f_floor;
	list["ceil"]		= f_ceil;
	list["frac"]		= f_frac;
	list["sqrt"]		= f_sqrt;
	list["sqr"]			= f_sqr;
	list["power"]		= f_power;
	list["exp"]			= f_exp;
	list["ln"]			= f_ln;
	list["log2"]		= f_log2;
	list["log10"]		= f_log10;
	list["logn"]		= f_logn;
	list["sin"]			= f_sin;
	list["cos"]			= f_cos;
	list["tang"]		= f_tan;
	list["arcsin"]		= f_arcsin;
	list["arctan"]		= f_arctan;
	list["arctan2"]		= f_arctan2;
	list["degtorad"]	= f_degtorad;
	list["radtodeg"]	= f_radtodeg;
	list["min2"]		= f_min2;
	list["min3"]		= f_min3;
	list["max2"]		= f_max2;
	list["max3"]		= f_max3;
	list["mean2"]		= f_mean2;
	list["mean3"]		= f_mean3;
	list["median2"]		= f_median2;
	list["median3"]		= f_median3;
	list["distance"]	= f_distance;
	list["direction"]	= f_direction;
	list["rgb"]			= f_rgb;
	list["hsv"]			= f_hsv;
	list["merge_color"]	= f_merge_color;
	list["getpixel"]	= f_getpixel;
	list["text_get_char"]= f_text_get_char;
	list["text_copy"]	= f_text_copy;
	list["text_copy"]	= f_text_copy;
	list["text_count"]	= f_text_count;
	list["text_delete"]	= f_text_delete;
	list["text_digits"]	= f_text_digits;
	list["text_height"]	= f_text_height;
	list["text_width"]	= f_text_width;
	list["text_insert"]	= f_text_insert;
	list["text_length"]	= f_text_length;
	list["clear"]		= f_clear;
	list["print"]		= f_print;
	list["alpha"]		= f_alpha;
	list["line_color"]	= f_line_color;
	list["line_width"]	= f_line_width;
	list["line_width_color"]= f_line_width_color;
	list["point"]		= f_point;
	list["point_color"]	= f_point_color;
	list["circle"]		= f_circle;
	list["circle_color"]= f_circle_color;
	list["ellipse"]		= f_ellipse;
	list["ellipse_color"]= f_ellipse_color;
	list["rectangle"]	= f_rectangle;
	list["rectangle_color"]	= f_rectangle_color;
	list["roundrect"]	= f_roundrect;
	list["roundrect_color"]= f_roundrect_color;
	list["arrow"]		= f_arrow;
	list["vertex"]		= f_vertex;
	list["vertex_color"]= f_vertex_color;
	list["triangle"]	= f_triangle;
	list["triangle_color"]= f_triangle_color;
	list["primitive_end"]= f_primitive_end;
	list["print_color"] = f_print_color;
	list["else"]		= f_else;
	list["{"]			= f_bbegin;
	list["}"]			= f_bend;
	list["exit"]		= f_exit;
	list["repeat"]		= f_repeat;
	list["message"]		= f_message;
	list["continue"]	= f_continue;
	list["switch"]		= f_switch;
	list["do"]			= f_do;
	list["case"]		= f_case;
	list["default"]		= f_default;
	list["break"]		= f_break;
	list["primitive_begin"]= f_primitive_begin;
	list["if"]			= f_if;
	list["while"]		= f_while;
	list["var"]			= f_var;
	list["function"]	= f_function;
	list["end"]			= f_end;
	list["return"]		= f_return;
}

ddlexport PCHAR Parser(const char *filename)
{
	fcode = "";
	new_fsize = 0;
	line_code.clear();
	list.clear();
	var.clear();
	var_local.clear();
	str.clear();
	fmap.clear();
	arg.clear();
	find_function();
	find_var();
	string parse_code = "";
	load_string("test.txt");
	for (unsigned i = 0; i< line_code.size(); i++)
	{
		str = line_code[i];
		if (str != "\n")
		{
			if(function_start)
			{
				fcode.append(Parsestring()+"\n");
			}
			else
				parse_code.append(Parsestring()+"\n");
		}
	}
	string variable = "";
	for(int i = 0; i <new_fsize; i++)
	{
		variable += fmap[i].name+"='"+fmap[i].name2+"'\n";
	}
	parse_code.assign(variable+parse_code);
	fstream plik;
	plik.open("temp.txt", ios_base::out);
	plik.write(parse_code.c_str(), (streamsize)parse_code.size());
	plik.close();
	return (PCHAR)parse_code.c_str();
}

ddlexport double Parser_add_global_arg_real(char* name, char* value)
{
	var[name] = value;
	return 0;
}

ddlexport double Parser_add_global_arg_string(char* name, char* value)
{
	var_string[name] = value;
	return 0;
}

ddlexport char* Parser_last_error()
{
	return (char*)last_error.c_str();
}